% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTAT-package.R
\docType{data}
\name{de.bioRxiv.240846}
\alias{de.bioRxiv.240846}
\title{Simulated \sQuote{3+3/PC} dose-titration study from bioRxiv paper no. 240846}
\format{
A length-10 list of data frames, each with the following columns:

\describe{
\item{id}{Participant identifier}
\item{period}{DLT assessment period, numbered consecutively from 1}
\item{dose}{Dose level, numbered consecutively starting from 1}
\item{dlt}{A logical indicator: did this this participant experience
a DLT during this period?}
}
}
\description{
This is a length-10 list of data frames, summarizing the simulated trial
from this paper, at the end of periods 1, 2, ..., 10. This structure reflects
an awkward S3 implementation that package DTAT v0.3 reimplemented using S4.
This data set is retained to support regression tests.
}
\details{
A \code{stop.esc} attribute is attached to data frames in this list,
indicating when escalation stopped during the simulated trial.
}
\examples{

data(de.bioRxiv.240846)
# Demonstrate that the new S4 3+3/PC implementation reproduces the
# simulated trial from the paper:
set.seed(2017)
CV <- 0.7; mean_mtd <- 1.0
shape <- CV^-2; scale <- mean_mtd/shape
trial <- new("DE", doses=0.25 * 1.4^(0:6),
             MTDi=rgamma(24, shape=shape, scale=scale),
             units="mg")
trial <- titration(trial, periods=10)
stopifnot(all(trial@data == de.bioRxiv.240846[[10]]))
stopifnot(trial@stop_esc == attr(de.bioRxiv.240846[[10]],'stop.esc'))

}
\references{
Norris DC. Precautionary Coherence Unravels Dose Escalation
Designs. \emph{bioRxiv}. December 2017:240846. \doi{10.1101/240846}.
\url{https://www.biorxiv.org/content/10.1101/240846v1}
}
\keyword{datasets}
