% Generated by roxygen2 (4.0.1): do not edit by hand
\name{make.simulation}
\alias{make.simulation}
\title{Creates a Simulation object}
\usage{
make.simulation(reps, single.transect.set = FALSE, double.observer = FALSE,
  region.obj, design.obj, population.description.obj, detectability.obj,
  ddf.analyses.list)
}
\arguments{
\item{reps}{number of times the simulation should be repeated}

\item{single.transect.set}{logical specifying whether the transects should
be kept the same throughout the simulation.}

\item{double.observer}{not currently implemented.}

\item{region.obj}{an object of class Region}

\item{design.obj}{an object of class Survey.Design}

\item{population.description.obj}{an object of class Population.Description}

\item{detectability.obj}{and object of class Detectabolity}

\item{ddf.analyses.list}{a list of objects of class DDF.Analysis}
}
\value{
object of class Simulation
}
\description{
This creates a simulation object which groups together all the objects
needed to complete the simulation.
}
\examples{
coords <- gaps <- list()
coords[[1]] <- list(data.frame(x = c(0,1000,1000,0,0), y = c(0,0,
 1000,1000,0)))
gaps[[1]] <- list(data.frame(x = c(400,600,500,350,400), y = c(100,
 250,600,120,100)))

region <- make.region(region.name = "study.area", units = "m",
 coords = coords, gaps = gaps)
plot(region)

\dontrun{
data(transects.shp)
#Edit the pathway below to point to an empty folder where the
#transect shapefile will be saved
shapefile.pathway <- "C:/..."
write.shapefile(transects.shp, paste(shapefile.pathway,"/transects_1",
 sep = ""))

parallel.design <- make.design(transect.type = "Line",
 design.details = c("Parallel","Systematic"), region = region,
 design.axis = 0, spacing = 100, plus.sampling =FALSE,
 path = shapefile.pathway)

pop.density <- make.density(region.obj = region, x.space = 10,
 y.space = 10, constant = 0.5)
pop.density <- add.hotspot(pop.density, centre = c(50, 200),
 sigma = 100, amplitude = 0.1)
pop.density <- add.hotspot(pop.density, centre = c(500, 700),
 sigma = 900, amplitude = 0.05)
pop.density <- add.hotspot(pop.density, centre = c(300, 100),
 sigma = 100, amplitude = -0.15)

plot(pop.density)
plot(region, add = TRUE)

pop.description <- make.population.description(N = 1000,
 density.obj = pop.density, region = region, fixed.N = TRUE)

detect <- make.detectability(key.function = "hn", scale.param = 15,
 truncation = 30)

ddf.analyses <- make.ddf.analysis.list(dsmodel = list(~cds(key = "hn",
 formula = ~1),~cds(key = "hr", formula = ~1)), method = "ds",
 criteria = "AIC")

my.simulation <- make.simulation(reps = 10, single.transect.set = TRUE,
 region.obj = region, design.obj = parallel.design,
 population.description.obj = pop.description,
 detectability.obj = detect, ddf.analyses.list = ddf.analyses)

survey.results <- create.survey.results(my.simulation, dht.table = TRUE)

plot(survey.results)

my.simulation <- run(my.simulation)

summary(my.simulation)
}
}
\author{
Laura Marshall
}

