% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMK.R
\name{AMK}
\alias{AMK}
\title{Additive Multiplicative Kernel Regression}
\usage{
AMK(
  trainX,
  trainY,
  testX,
  bw = "dpi_gap",
  nMultiCov = 3,
  fixedCov = c(1, 2),
  cirCov = NA
)
}
\arguments{
\item{trainX}{a matrix or dataframe of input variable values in the training dataset.}

\item{trainY}{a numeric vector for response values in the training dataset.}

\item{testX}{a matrix or dataframe of test input variable values to compute predictions.}

\item{bw}{a numeric vector or a character input for bandwidth. If character, bandwidth computed internally; the input should be either \code{'dpi'} or \code{'dpi_gap'}. Default is \code{'dpi_gap'}. See \code{details} for more information.}

\item{nMultiCov}{an integer or a character input specifying the number of multiplicative covariates in each additive term. Default is 3 (same as Lee et al., 2015). The character inputs can be: \code{'all'} for a completely multiplicative model, or \code{'none'} for a completely additive model. Ignored if the number of covariates is 1.}

\item{fixedCov}{an integer vector specifying the fixed covariates column number(s), default value is \code{c(1,2)}. Ignored if \code{nMultiCov} is set to \code{'all'} or \code{'none'} or if the number of covariates is less than 3.}

\item{cirCov}{an integer vector specifying the circular covariates column number(s) in \code{trainX}, default value is \code{NA}.}
}
\value{
a numeric vector for predictions at the data points in \code{testX}.
}
\description{
An additive multiplicative kernel regression based on Lee et al. (2015).
}
\details{
This function is based on Lee et al. (2015). Main features  are: 
\itemize{
\item Flexible number of multiplicative covariates in each additive term, which can be set using \code{nMultiCov}.
\item Flexible number and columns for fixed covariates, which can be set using \code{fixedCov}. The default option \code{c(1,2)} sets the first two columns as fixed covariates in each additive term.
\item Handling the data with gaps when the direct plug-in estimator used in Lee et al. fails to return a finite bandwidth. This is set using the option \code{bw = 'dpi_gap'} for bandwidth estimation.  
}
}
\examples{
data = data1
trainX = as.matrix(data[c(1:100),2])
trainY = data[c(1:100),7]
testX = as.matrix(data[c(101:110),2])
AMK_prediction = AMK(trainX, trainY, testX, bw = 'dpi_gap', cirCov = NA)

}
\references{
Lee, Ding, Genton, and Xie, 2015, “Power curve estimation with multivariate environmental factors for inland and offshore wind farms,” Journal of the American Statistical Association, Vol. 110, pp. 56-67, DOI:10.1080/01621459.2014.977385.
}
