# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title
#' getneighborhood_fast
#' @description
#' an efficient function to find the neighborhood based on the matrix of position and a pre-defined cutoff
#'
#' @param x is a n-by-2 matrix of position.
#' @param radius is a threashold of Euclidean distance to decide whether a spot is an neighborhood of another spot. For example, if the Euclidean distance between spot A and B is less than cutoff, then A is taken as the neighbourhood of B. 
#' @return A sparse matrix containing the neighbourhood
#'
#' @export
getneighborhood_fast <- function(x, radius) {
    .Call(`_DR_SC_getneighborhood_fast`, x, radius)
}

#' Calculate column-wise or row-wise mean
#' @param sp_data A sparse matrix
#' @param rowMeans A boolean value, whether to calculate row-wise mean
#' @return A n x 1 or p x 1 matrix 
#' @export
sp_means_Rcpp <- function(sp_data, rowMeans = FALSE) {
    .Call(`_DR_SC_sp_means_Rcpp`, sp_data, rowMeans)
}

#' Calculate column-wise or row-wise sum
#' @param sp_data A sparse matrix
#' @param rowSums A boolean value, whether to calculate row-wise sum
#' @return A n x 1 or p x 1 matrix 
#' @export
sp_sums_Rcpp <- function(sp_data, rowSums = FALSE) {
    .Call(`_DR_SC_sp_sums_Rcpp`, sp_data, rowSums)
}

#' @keywords internal
#' @noRd
#' 
#' Data X has been centered.
NULL

getPairDist <- function(x) {
    .Call(`_DR_SC_getPairDist`, x)
}

calYenergy2D_sp <- function(y, Adj, K, alpha, beta) {
    .Call(`_DR_SC_calYenergy2D_sp`, y, Adj, K, alpha, beta)
}

obj_beta <- function(y, R, Adj, K, alpha, beta) {
    .Call(`_DR_SC_obj_beta`, y, R, Adj, K, alpha, beta)
}

icmem_heterCpp <- function(X, Adj, y_int, Mu_int, W_int, Sigma_int, Lam_vec_int, alpha, beta_int, beta_grid, maxIter_ICM, maxIter, epsLogLik, verbose, homo = FALSE, diagSigmak = FALSE) {
    .Call(`_DR_SC_icmem_heterCpp`, X, Adj, y_int, Mu_int, W_int, Sigma_int, Lam_vec_int, alpha, beta_int, beta_grid, maxIter_ICM, maxIter, epsLogLik, verbose, homo, diagSigmak)
}

EMmPCpp_heter <- function(X, Pi_int, Mu_int, W_int, Sigma_int, Lam_vec_int, maxIter, epsLogLik, verbose, homo = FALSE, diagSigmak = FALSE) {
    .Call(`_DR_SC_EMmPCpp_heter`, X, Pi_int, Mu_int, W_int, Sigma_int, Lam_vec_int, maxIter, epsLogLik, verbose, homo, diagSigmak)
}

#' @keywords internal
#' @noRd
#' 
#' Data X has been centered.
NULL

#' Evaluate the log determinant of the covariance matrix and energy function values on each sample
#' point, by SVD decomposition to achieve efficeint computation.
#' @param X: a n x p  matrix, such as gene expression logcount matrix
#' @param Lam_vec0: a column vector, variance of each error component in factor model
#' @param W0: a p x q matrix, loading matrix
#' @param Ck: a q x q matrix,
#' @param Muk: a q x K matrix, gaussian mixture mean component
#' @param logdSk: a real number, the returned log determinant of covariance matrix
#' @param mSk: a colunmn vector, the returned energy funciton values. 
#' 
#' @return No return
#' 
NULL

#' Evaluate the diagonal elements of three matrix multiplication such as W0*Cki*W0^T
#'  by SVD decomposition to achieve efficeint computation.
#' @param Cki: a q x q matrix,
#' @param W0: a p x q matrix
#' 
#' @return a column vector
#'   
NULL

#' Evaluate the diagonal elements of three matrix multiplication such as W0*Cki*W0^T
#'  by SVD decomposition to achieve efficeint computation.
#' @param Cki: a q x q matrix,
#' @param W0: a p x q matrix
#' 
#' @return a column vector
#'   
NULL

#' @noRd
#' 
calculateWeight <- function(X, nPCs) {
    .Call(`_DR_SC_calculateWeight`, X, nPCs)
}

wpcaCpp <- function(X, nPCs, weighted = TRUE) {
    .Call(`_DR_SC_wpcaCpp`, X, nPCs, weighted)
}

