% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pContrib.R
\name{pContrib_locus}
\alias{pContrib_locus}
\title{Compute the posterior probabilities for \eqn{\Pr(m|n_0)}{Pr(m|n0)} for a given prior 
\eqn{\Pr(m)}{Pr(m)}.}
\usage{
pContrib_locus(
  prob = NULL,
  m.prior = NULL,
  m.max = 8,
  pnoa.locus = NULL,
  theta = 0
)
}
\arguments{
\item{prob}{Vectors with allele probabilities for the specific locus}

\item{m.prior}{A vector with prior probabilities (summing to 1), where the
length of \code{m.prior} determines the plausible range of \eqn{m}}

\item{m.max}{Derived from the length of \code{m.prior}, and if
\code{m.prior=NULL} a uniform prior is speficied by \code{m.max}:
\code{m.prior = rep(1/m.max,m.max)}.}

\item{pnoa.locus}{A named vector of locus specific probabilities
\eqn{P(N(m)=n), n=1,\ldots,2m}{P(N(m)=n), n=1,\ldots,2m}.}

\item{theta}{The coancestery coefficient}
}
\value{
Returns a matrix \eqn{[\Pr(m|n_0)]}{[Pr(m|n0)]} for 
\eqn{m = 1,\ldots,m.max} and \eqn{n_0 = 1,\ldots,2m.max}{n_0 = 1,\ldots,2m.max}.
}
\description{
Compute a matrix of posterior probabilties \eqn{\Pr(m|n_0)}{P(m|n0)} where \eqn{m}
ranges from 1 to \eqn{m_{\max}}{\code{m.max}}, and \eqn{n_0}{n0} is
\eqn{0,\ldots,2m_{\max}}{0,\ldots,\code{m.max}}. This is done by evaluating
\eqn{\Pr(m|n_0)=Pr(n_0|m)Pr(m)/Pr(n)}{Pr(m|n0)=Pr(n0|m)Pr(m)/Pr(n)}, where
\eqn{\Pr(n_0|m)}{Pr(n0|m)} is evaluated by \code{\link{pNoA}}.
}
\details{
Computes a matrix of \eqn{\Pr(m|n_0)}{Pr(m|n0)} values for a specific locus.
}
\examples{

  ## Simulate some allele frequencies:
  freqs <-  simAlleleFreqs()
  
  ## Compute Pr(m|n0) for m = 1, ..., 5 and n0 = 1, ..., 10 for the first locus:
  pContrib_locus(prob = freqs[[1]], m.max = 5)

}
\references{
T. Tvedebrink (2014). 'On the exact distribution of the number of 
alleles in DNA mixtures', International Journal of Legal Medicine; 128(3):427--37. 
<https://doi.org/10.1007/s00414-013-0951-3>
}
\author{
Torben Tvedebrink, James Curran
}
