% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/est.freqs.R
\name{est.freqs}
\alias{est.freqs}
\title{Estimate allelic frequencies in reference database}
\usage{
est.freqs(x, labels)
}
\arguments{
\item{x}{profiles object}

\item{labels}{(optional) list of per-locus labels of alleles (repeat numbers for integers, like factor levels)}
}
\description{
Estimate allelic frequencies in reference database
}
\details{
The allele frequencies are estimated using the counting method. That is, the empirical fraction of each allele is taken as an estimate of the frequency.

         Since alleles are stored as integer, labels can be supplied that map the integer to a repeat number (similar to a factor level). See below for an example.
}
\examples{
data(freqsNLsgmplus)

set.seed(123)

# sample a small reference db
x <- sample.profiles(N = 1e3,freqs=freqsNLsgmplus)

# estimate frequencies
fr0 <- est.freqs(x,labels = lapply(get.freqs(x),names))

# mean absolut difference between fr0 and freqsNLsgmplus is small
mean(abs(c(fr0,recursive = TRUE)-c(freqsNLsgmplus,recursive=TRUE)))
}

