% Generated by roxygen2 (4.0.1): do not edit by hand
\name{recode.freqs}
\alias{recode.freqs}
\title{Recode allelic frequencies with different levels}
\usage{
recode.freqs(freqs, along.with)
}
\arguments{
\item{freqs}{list with named numeric vectors \code{x} and \code{fx}, denoting respectively the events and probabilities of the discrete distribution.}

\item{along.with}{second list of allelic frequencies from which the levels are taken}
}
\value{
list with named numeric vectors \code{x} and \code{fx}, denoting respectively the events and probabilities of the discrete distribution.
}
\description{
Recode allelic frequencies with different levels
}
\details{
Profiles are stored with integers corresponding to the corresponding index of the names attribute of the allelic frequencies. This funciton recodes a set of frequencies to include all names of a larger set of allelic frequencies.
}
\examples{
# The following example demonstrates the effect of having a small reference database on LRs
# We sample a small reference db and compute LRs with estimated frequencies

data(freqsNLsgmplus)

fr.true <- freqsNLsgmplus

# sample a small db
n <- 1e2
x <- sample.profiles(n,fr.true)
x.char <- profiles.to.chars(x,two.cols.per.locus = TRUE)

# estimate frequencies
fr.hat <- list()
for (L in names(fr.true)){
 f0.tab <- table(x.char[,paste(L,c(".1",".2"),sep = "")])
 fr.hat[[L]] <- setNames(as.vector(f0.tab)/(2*n),names(f0.tab))
}

# not all alleles are seen in the sample, so the ladders don't line up
# rmp(x,fr.hat) # reallly wrong!
fr.hat <- recode.freqs(freqs = fr.hat,along.with = fr.true) # fix

plot(log10(rmp(x)),log10(rmp(x,freqs = fr.hat)))
abline(a=0,b=1)
}

