% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIscBIO-generic-NoiseFiltering.R
\name{NoiseFiltering}
\alias{NoiseFiltering}
\alias{NoiseFiltering,DISCBIO-method}
\title{Noise Filtering}
\usage{
NoiseFiltering(
  object,
  percentile = 0.8,
  CV = 0.3,
  geneCol = "yellow",
  FgeneCol = "black",
  erccCol = "blue",
  Val = TRUE,
  plot = TRUE,
  export = FALSE,
  quiet = FALSE,
  filename = "Noise_filtering_genes_test"
)

\S4method{NoiseFiltering}{DISCBIO}(
  object,
  percentile = 0.8,
  CV = 0.3,
  geneCol = "yellow",
  FgeneCol = "black",
  erccCol = "blue",
  Val = TRUE,
  plot = TRUE,
  export = FALSE,
  quiet = FALSE,
  filename = "Noise_filtering_genes_test"
)
}
\arguments{
\item{object}{\code{DISCBIO} class object.}

\item{percentile}{A numeric value of the percentile. It is used to validate
the ERCC spik-ins. Default is 0.8.}

\item{CV}{A numeric value of the coefficient of variation. It is used to
validate the ERCC spik-ins. Default is 0.5.}

\item{geneCol}{Color of the genes that did not pass the filtration.}

\item{FgeneCol}{Color of the genes that passt the filtration.}

\item{erccCol}{Color of the ERCC spik-ins.}

\item{Val}{A logical vector that allows plotting only the validated ERCC
spike-ins. Default is TRUE. If Val=FALSE will plot all the ERCC spike-ins.}

\item{plot}{A logical vector that allows plotting the technical noise.
Default is TRUE.}

\item{export}{A logical vector that allows writing the final gene list in
excel file. Default is TRUE.}

\item{quiet}{if `TRUE`, suppresses printed output}

\item{filename}{Name of the exported file (if `export=TRUE`)}
}
\value{
The DISCBIO-class object input with the noiseF slot filled.
}
\description{
Given a matrix or data frame of count data, this function
  estimates the size factors as follows: Each column is divided by the
  geometric means of the rows. The median (or, if requested, another location
  estimator) of these ratios (skipping the genes with a # geometric mean of
  zero) is used as the size factor for this column. Source: DESeq package.
}
\note{
This function should be used only if the dataset has ERCC.
}
\examples{
sc <- DISCBIO(valuesG1msTest) # changes signature of data
sd_filtered <- NoiseFiltering(sc, export = FALSE)
str(sd_filtered)

}
