% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBenchmarks.R
\name{benchmarkRuntime}
\alias{benchmarkRuntime}
\title{Benchmark runtimes of several functions}
\usage{
benchmarkRuntime(createModel, evaluationFunctions, n)
}
\arguments{
\item{createModel}{a function that creates and returns a fitted model}

\item{evaluationFunctions}{a list of functions that are to be evaluated on the fitted models}

\item{n}{number of replicates}
}
\description{
Benchmark runtimes of several functions
}
\details{
This is a small helper function designed to benchmark runtimes of several operations that are to be performed on a list of fitted models. In the example, this is used to benchmark the runtimes of several DHARMa tests
}
\examples{

createModel = function(){
  testData = createData(family = poisson(), overdispersion = 1,
                        randomEffectVariance = 0)
  fittedModel <- glm(observedResponse ~ Environment1, data = testData, family = poisson())
  return(fittedModel)
}

a = function(m){
  testUniformity(m, plot = FALSE)$p.value
}

b = function(m){
  testDispersion(m, plot = FALSE)$p.value
}

c = function(m){
  testDispersion(m, plot = FALSE, type = "PearsonChisq")$p.value
}


evaluationFunctions = list(a,b, c)

benchmarkRuntime(createModel, evaluationFunctions, 2)
}
\author{
Florian Hartig
}
