% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compatibility.R
\name{getSimulations}
\alias{getSimulations}
\alias{getSimulations.default}
\alias{getSimulations.negbin}
\alias{getSimulations.gam}
\alias{getSimulations.lmerMod}
\alias{getSimulations.glmmTMB}
\alias{getSimulations.HLfit}
\alias{getSimulations.MixMod}
\title{Get model simulations}
\usage{
getSimulations(object, nsim = 1, type = c("normal", "refit"), ...)

\method{getSimulations}{default}(object, nsim = 1, type = c("normal", "refit"), ...)

\method{getSimulations}{negbin}(object, nsim = 1, type = c("normal", "refit"), ...)

\method{getSimulations}{gam}(object, nsim = 1, type = c("normal", "refit"),
  mgcViz = TRUE, ...)

\method{getSimulations}{lmerMod}(object, nsim = 1, type = c("normal", "refit"), ...)

\method{getSimulations}{glmmTMB}(object, nsim = 1, type = c("normal", "refit"), ...)

\method{getSimulations}{HLfit}(object, nsim = 1, type = c("normal", "refit"), ...)

\method{getSimulations}{MixMod}(object, nsim = 1, type = c("normal", "refit"), ...)
}
\arguments{
\item{object}{a fitted model}

\item{nsim}{number of simulations}

\item{type}{if simulations should be prepared for getQuantile or for refit}

\item{...}{additional parameters to be passed on, usually to the simulate function of the respective model class}

\item{mgcViz}{whether simulations should be created with mgcViz (if mgcViz is available)}
}
\value{
a matrix with simulations
}
\description{
Wrapper to simulate from a fitted model
}
\details{
The purpose of this wrapper for for the simulate function is to return the simulations from a model in a standardized way

The purpose of this function is to wrap or implement the simulate function of different model classes and thus return simulations from fitted models in a standardized way.

Note: GLMM and other regression packages often differ in how simulations are produced, and which parameters can be used to modify this behavior.

One important difference is how to modifiy which hierarchical levels are held constant, and which are re-simulated. In lme4, this is controlled by the re.form argument (see \link[lme4:simulate.merMod]{lme4::simulate.merMod}). For other packages, please consort the help.

If the model was fit with weights and the respective model class does not include the weights in the simulations, getSimulations will throw a warning. The background is if weights are used on the likelihood directly, then what is fitted is effectively a pseudo likelihood, and there is no way to directly simulate from the specified likelihood. Whether or not residuals can be used in this case depends very much on what is tested and how weights are used. I'm sorry to say that it is hard to give a general recommendation, you have to consult someone that understands how weights are processed in the respective model class.
}
\examples{
testData = createData(sampleSize = 400, family = gaussian())

fittedModel <- lm(observedResponse ~ Environment1 , data = testData)

# response that was used to fit the model
getObservedResponse(fittedModel)

# predictions of the model for these points
getFitted(fittedModel)

# extract simulations from the model as matrix
getSimulations(fittedModel, nsim = 2)

# extract simulations from the model for refit (often requires different structure)
x = getSimulations(fittedModel, nsim = 2, type = "refit")

getRefit(fittedModel, x[[1]])

getRefit(fittedModel, getObservedResponse(fittedModel))
}
\seealso{
\code{\link{getObservedResponse}}, \code{\link{getRefit}}, \code{\link{getFixedEffects}}, \code{\link{getFitted}}
}
\author{
Florian Hartig
}
