% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compatibility.R
\name{getFixedEffects}
\alias{getFixedEffects}
\alias{getFixedEffects.default}
\alias{getFixedEffects.MixMod}
\title{Extract fixed effects of a supported model}
\usage{
getFixedEffects(object, ...)

\method{getFixedEffects}{default}(object, ...)

\method{getFixedEffects}{MixMod}(object, ...)
}
\arguments{
\item{object}{a fitted model}

\item{...}{additional parameters}
}
\description{
A wrapper to extract fixed effects of a supported model
}
\examples{
testData = createData(sampleSize = 400, family = gaussian())

fittedModel <- lm(observedResponse ~ Environment1 , data = testData)

# response that was used to fit the model
getObservedResponse(fittedModel)

# predictions of the model for these points
getFitted(fittedModel)

# extract simulations from the model as matrix
getSimulations(fittedModel, nsim = 2)

# extract simulations from the model for refit (often requires different structure)
x = getSimulations(fittedModel, nsim = 2, type = "refit")

getRefit(fittedModel, x[[1]])

getRefit(fittedModel, getObservedResponse(fittedModel))
}
\seealso{
\code{\link{getObservedResponse}}, \code{\link{getSimulations}}, \code{\link{getRefit}}, \code{\link{getFitted}}
}
