% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry.R
\name{getEllipsoid}
\alias{getEllipsoid}
\title{Calculate an ellipsoid}
\usage{
getEllipsoid(radius = 0.5, height = 1, faces = c(6, 3))
}
\arguments{
\item{radius}{x/y radius}

\item{height}{z height}

\item{faces}{approx. number of faces. If two values given: 1.) around z-axis; 2.) along z-axis.}
}
\value{
a \code{\link{TriangBody-class}}
}
\description{
Calculate an ellipsoid
}
\examples{
if (require(rgl)) {
  ellipsoid=getEllipsoid(height=2)
  triangles3d(ellipsoid@vertices[ellipsoid@id, ], col="green")
} else {
  message("the library 'rgl' is required for this example!")
}
}
