% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ships_methods.R
\name{read.DeponsShips}
\alias{read.DeponsShips}
\title{Read DEPONS ship files}
\usage{
read.DeponsShips(fname, title = "NA", landscape = "NA", crs = as.character(NA))
}
\arguments{
\item{fname}{Name of the file (character) where ship routes and ships
are defined.}

\item{title}{Optional character string with the name of the simulation}

\item{landscape}{Optional character string with the landscape used in the
simulation}

\item{crs}{Character, coordinate reference system (map projection)}
}
\value{
Returns an object with the elements \code{title} \code{landscape},
\code{crs}, \code{routes} and \code{ships}.
}
\description{
Function  for reading the json-files that are used for controlling
how ship agents behave in DEPONS. Ships move along pre-defined routes in 30-min
time steps. The routes are defined by the fix-points provided in the
json file, and the geographic projection is assumed to match that of the
landscape.
}
\seealso{
\code{\link{ais.to.DeponsShips}}, \code{\link[DEPONS2R]{write.DeponsShips}}
}
