% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ships_methods.R
\name{plot,DeponsShips,missing-method}
\alias{plot,DeponsShips,missing-method}
\alias{plot.DeponsShips}
\title{Plot a DeponsShips object}
\usage{
\S4method{plot}{DeponsShips,missing}(x, y, ...)
}
\arguments{
\item{x}{DeponsShips object}

\item{y}{Not used}

\item{...}{Optional plotting parameters, including 'col', 'main',
'add.legend', and 'legend.xy' (defaults to 'topright' when add.legend=TRUE)}
}
\value{
No return value, called for side effects
}
\description{
Plot the tracks that ship agents move along in DEPONS.
}
\examples{
data(shipdata)
plot(shipdata, col=c("red", "green", "blue"))

\donttest{
# convert route coordinate units from 'grid squares' to UTM
data(bathymetry)
out <- summary(bathymetry)
left <- out[[4]][1]
bottom <- out[[4]][2]
for (i in 1:3) {
    newroute <- shipdata@routes[[2]][[i]]*400
    newroute$x <- newroute$x + as.numeric(left)
    newroute$y <- newroute$y + as.numeric(bottom)
    shipdata@routes[[2]][[i]] <- newroute
    }

# Reproject coastline and clip to size of Kattegat landscape
library(sp)
data(bathymetry)
data(coastline)
coastline_sf <- sf::st_as_sf(coastline)
coastline2 <- sf::st_transform(coastline_sf, crs(bathymetry))
bbox <- bbox(bathymetry)
clip.poly <- make.clip.poly(bbox, crs(bathymetry))
plot(shipdata, col=c("red", "green", "blue"), add=TRUE, add.legend=TRUE)
plot(clip.poly, add=TRUE)
}
}
