\name{DEMEtics-package}
\alias{DEMEtics}
\docType{package}
\title{
Evaluating the genetic differentiation between populations based on Gst and D values.
}
\description{
This package allows to calculate the fixation index Gst
(Nei, 1973) and the differentiation index D (Jost, 2008) pairwise
between or averaged over several populations.  P-values, stating the
significance of differentiation, and 95 percent confidence intervals
can be estimated using bootstrap resamplings. In the case that more
than two populations are compared pairwise, the p-values are
adjusted by bonferroni correction and in several other ways due to
the multiple comparison from one data set.
}
\details{
\tabular{ll}{
Package: \tab DEMEtics\cr
Type: \tab Package\cr
Version: \tab 0.8-5\cr
Date: \tab 2012-02-26\cr
Depends: \tab R (>= 2.8.0)\cr
License: \tab GPL (>= 2)\cr
Literature:
\tab Gerlach G., Jueterbock A., Kraemer P., Deppermann J. and Harmand P. 2010\cr
\tab Calculations of population differentiation based on Gst and D:\cr 
\tab forget Gst but not all of statistics!\cr
\tab \emph{Molecular Ecology} \bold{19}, p. 3845--3852.\cr
\tab \cr
\tab Goudet J., Raymond M., deMeeues T. and Rousset F. 1996\cr
\tab Testing differentiation in diploid populations.\cr
\tab \emph{Genetics} \bold{144}, 4, p. 1933--1940.\cr
\tab \cr
\tab Jost, L. 2008\cr
\tab Gst and its relatives do not measure differentiation.\cr
\tab \emph{Molecular Ecology} \bold{17}, 18, p. 4015--4026.\cr
\tab \cr
\tab Manly, B.F.J. 1997\cr
\tab \emph{Randomization, bootstrap and Monte Carlo methods in
  biology}\cr
\tab Chapman & Hall.\cr
\tab \cr
\tab Nei, M. 1973\cr
\tab Analysis of gene diversity in subdivided populations.\cr
\tab \emph{Proceedings of the National Academy of Sciences of the United
  States of America}\cr
\tab \bold{70}, 12, p. 3321--3323.\cr
\tab \cr
\tab Nei M., Chesser R. 1983\cr
\tab Estimation of fixation indices and gene diversities.\cr
\tab \emph{Annals of Human Genetics} \bold{47}, 253--259.\cr
\tab \cr
\tab Wright, S.P. 1992\cr
\tab Adjusted p-values for simultaneous inference.\cr
\tab \emph{Biometrics} \bold{48}, 1005--1013.\cr
LazyLoad: \tab yes\cr
Packaged: \tab 2010-12-18 13:48:33 UTC; alexj\cr
Built: \tab R 2.10.1; ; 2010-12-18 13:48:39 UTC; unix\cr
}

Index:
\preformatted{
D.Jost-and-Gst.Nei      Comparing Populations - Differentiation and
                        Fixation Indices
Example.transformed     Allelic Data of Three Populations For Three
                        Loci
Example.untransformed   Allelic Data of Three Populations for Three
                        Loci
}
}
\author{
Alexander Jueterbock, Philipp Kraemer, Gabriele Gerlach and Jana Deppermann

Maintainer: Alexander Jueterbock, <Alexander-Jueterbock@web.de> }

\section{Citation}{To cite the package 'DEMEtics' in publications use:\cr\cr
Gerlach, G., Jueterbock, A., Kraemer, P., Deppermann, J. and Harmand,
P. 2010\cr Calculations of population differentiation based on G(ST) and D:
forget G(ST)\cr but not all of statistics! \emph{Molecular Ecology}
\bold{19}, 3845-3852}

\keyword{package}
