% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knutils.R
\name{mergeknclusters}
\alias{mergeknclusters}
\title{Merges clusters so that they are identifed as levels of a factor.}
\usage{
mergeknclusters(datamap, knresults, indClustersPlot)
}
\arguments{
\item{datamap}{data of the \link{SpatialPolygonsDataFrame} with the polygons
of the map.}

\item{knresults}{Data frame with information of the detected clusters.
Each row represents the information of one of the clusters.
It contains the coordinates of the center, the size, the start
and end dates, the log-likelihood ratio, a boolean indicating if it is a
cluster (TRUE in all cases), and the p-value of the cluster.}

\item{indClustersPlot}{rows of knresults that denote the clusters to be plotted.}
}
\value{
factor with levels that represent the clusters.
}
\description{
Given a data frame with clusters that do not overlap 
this function merges the clusters and construct a factor.
The levels of the factor are "NCL" if the polygon of the map is not
in any cluster, and "CL" if the polygon i is in cluster i.
}
\examples{
library("DClusterm")
library("RColorBrewer")

data("NY8")
data("NY8_clusters")

stcl <- mergeknclusters(NY8, ny.cl1, 1:2)
#Get first cluster
NY8$CLUSTER <- stcl

#Plot cluster
spplot(NY8, "CLUSTER", col.regions = c("white", "lightgray", "gray"))

}
