% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions2.R
\name{CalcStatClusterGivenCenter}
\alias{CalcStatClusterGivenCenter}
\title{Calls the function to obtain the cluster with the maximum log-likelihood ratio
or minimum DIC of all the clusters with the same center and start and end dates.}
\usage{
CalcStatClusterGivenCenter(point, stfdf, rr, minDateCluster, maxDateCluster,
  fractpop, model0, ClusterSizeContribution)
}
\arguments{
\item{point}{vector with the coordinates of the center of the cluster.}

\item{stfdf}{spatio-temporal class object containing the data.}

\item{rr}{square of the maximum radius of the cluster.}

\item{minDateCluster}{start date of the cluster.}

\item{maxDateCluster}{end date of the cluster.}

\item{fractpop}{maximum fraction of the total population inside the cluster.}

\item{model0}{Initial model (including covariates).}

\item{ClusterSizeContribution}{Variable used to check the fraction of the 
population at risk in the cluster
This can be "glm" for generalized linear models (\link{glm} {stats}),
"glmer" for generalized linear mixed model (\link{glmer} {lme4}),
"zeroinfl" for zero-inflated models (\link{zeroinfl} {pscl}), or
"inla" for generalized linear, generalized linear mixed or zero-inflated models fitted with \link[INLA]{inla}.}
}
\value{
vector containing the coordinates of the center, the size,
the start and end dates, the log-likelihood ratio or DIC, the p-value and 
the risk of the cluster with the maximum log-likelihood ratio or minimum DIC.
}
\description{
This function orders the regions according to the distance to a given center
and selects the regions with distance to the center less than sqrt(rr).
Then it calls glmAndZIP.iscluster() to obtain the cluster with the maximum
log-likelihood ratio or minimum DIC of all the clusters with the same center
and start and end dates, and where the maximum fraction of the total
population inside the cluster is less than fractpop.
}
