% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCS_MainFunctions.R
\name{kernel.assign}
\alias{kernel.assign}
\title{Assign a Kernel Function}
\usage{
kernel.assign(kernel_id)
}
\arguments{
\item{kernel_id}{a string specifying the kernel identifier as given in the
details.}
}
\value{
\code{kernel.assign} returns an object of class "function". This
 function takes two arguments, a numeric vector in the first argument and a
 single number in the second. The function itself will return a matrix with
 one column and the same number of rows as the input vector.
}
\description{
Assign a Kernel Function
}
\section{Details}{

\code{kernel.assign} sets a pointer to a specified kernel function available 
 in the DCSmooth package. The kernels are boundary kernels of the form
 \eqn{K(u,q)}, where \eqn{u \in [-1, q]}{u = [-1, q]} and \eqn{q \in [0, 1]}
 {q = [0, 1]}. Kernels are of the Müller-Wang type ("MW"), Müller type ("M")
 or truncated kernels ("TR").
}

\examples{
 # See vignette("DCSmooth") for further examples and explanation

u <- seq(from = -1, to = 0.5, length.out = 151)
kern_MW220 <- kernel.assign("MW_220")
k <- kern_MW220(u, 0.5)
plot(u, k, type = "l") 

}
\references{
Müller, H.-G. and Wang, J.-L. (1994). Hazard rate estimation under random
 censoring with varying kernels and bandwidths. Biometrics, 50:61-76.
 
 Müller, H.-G. (1991). Smooth optimum kernel estimators near endpoints.
 Biometrika, 78:521-530.
 
 Feng, Y. and Schäfer B. (2021). Boundary Modification in Local Regression.
 Working Papers CIE 144, Paderborn University.
}
\seealso{
\code{\link{kernel.list}}
}
