#' Single Gaussian Peak
#' 
#' Example data for using the DCSmooth functions. Data resembles a single
#'   gaussian peak on the interval \eqn{[0,1] \times [0,1]}{[0,1] x [0,1]}
#'   with maximum at \eqn{(0.5, 0.5)} and variance matrix \eqn{0.1 \cdot
#'  {\bf I}}{0.1 I}, where 
#'   \eqn{{\bf I}}{I} represents the \eqn{2 \times 2}{2 x 2} identity matrix.
#'   
#' @format A numeric matrix with 101 rows and 101 columns.
"y.norm1"

#' Double Gaussian Peak
#' 
#' Example data for using the DCSmooth functions. Data resembles two gaussian
#'   peaks on the interval \eqn{[0,1] \times [0,1]}{[0,1] x [0,1]} with maxima
#'   at \eqn{(0.5, 0.3)} with variance matrix \eqn{0.1 \cdot {\bf I}}{0.1 I}
#'   and at \eqn{(0.2, 0.8)} with variance matrix \eqn{0.05 \cdot {\bf I}}{
#'   0.05 I}, where 
#'   \eqn{{\bf I}}{I} represents the \eqn{2 \times 2}{2 x 2} identity matrix.
#'   
#' @format A numeric matrix with 101 rows and 101 columns.
"y.norm2"

#' Double Gaussian Ridges
#' 
#' Example data for using the DCSmooth functions. Data resembles two gaussian
#'   ridges on the interval \eqn{[0,1] \times [0,1]}{[0,1] x [0,1]} with maxima
#'   at \eqn{(0.25, 0.75)} with variance matrix
#'   \eqn{(0.01, -0.1) \cdot {\bf I}}{(0.01, -0.1) I} and at
#'   \eqn{(0.75, 0.5)} with variance matrix
#'   \eqn{(0.01, -0.1) \cdot {\bf I}}{(0.01, -0.1) I}, where 
#'   \eqn{{\bf I}}{I} represents the \eqn{2 \times 2}{2 x 2} identity matrix.
#'   
#' @format A numeric matrix with 101 rows and 101 columns.
"y.norm3"
