% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBERlibR.R
\name{one_way_ancova}
\alias{one_way_ancova}
\title{One-way ANCOVA}
\usage{
one_way_ancova(
  treat_pre_csv_data,
  treat_post_csv_data,
  ctrl_pre_csv_data,
  ctrl_post_csv_data,
  m_cutoff = 0.15
)
}
\arguments{
\item{treat_pre_csv_data}{This function requires a csv file with treatment
group's pre-test data. Its name (e.g., "data_treat_pre.csv") can be passed
as an argument. Make sure to set the folder with the data file(s) as the
working directory.}

\item{treat_post_csv_data}{This function requires a csv file with treatment
group's post-test data. Its name (e.g., "data_treat_post.csv") can be passed
as an argument. Make sure to set the folder with the data file(s) as the
working directory.}

\item{ctrl_pre_csv_data}{This function requires a csv file with control
group's pre-test. Its name (e.g., "data_ctrl_pre.csv") can be passed as an
argument. Make sure to set the folder with the data file(s) as the working
directory.}

\item{ctrl_post_csv_data}{This function requires a csv file with control
group's post-test data. Its name (e.g., "data_ctrl_post.csv") can be passed
as an argument. Make sure to set the folder with the data file(s) as the
working directory.}

\item{m_cutoff}{This package will treat skipped answers as incorrect.
However, too many skipped answers may skew the results of the data analysis.
User can can provide a cutoff for the proportion of skipped answers.
For example, if the user enters 0.1, students who skipped more than
10 percent of the answers will be excluded from the data analysis to prevent
skewed results. The default of 0.15 is commonly applied as a rule of thumb.}
}
\value{
This function returns a \code{tibble()} including the following
information:
\itemize{
 \item \code{n_students_deleted}: Number of students deleted from the data
 for analysis based on the percentage obtained via the argument of m_cutoff
 \item \code{pre_descriptive_statistics}: Pre-test data descriptive statistics
 \item \code{post_descriptive_statistics}: Post-test data descriptive statistics
 \item \code{boxplots}: Boxplots - visual presentation of the descriptive
 statistics
 \item \code{scatter_plot}: Scatter plots to test the linearity
 statistics
 \item \code{shapiro_wilk_test}: Shapiro-Wilk test results to determine
 normality of residuals
 \item \code{normal_qq_plot}: The normal q-q plot to visually inspect the
 normality of residuals
 \item \code{levene_test}: Test homogeneity of variances
 \item \code{independent_samples_t_test_equal}: Results of the independent
 samples t-test with equal variances assumed
 \item \code{one_way_ancova}: Results of the one-way ANCOVA
 \item \code{estimated_marginal_means}: Estimated marginal means
}
}
\description{
This function automatically merges pre-post data sets, binds
treatment-control data sets, checks assumptions of one-way ANCOVA,
and then runs the main One-way ANCOVA all at once. Please make sure to name
data files accurately (i.e., "data_treat_pre.csv", "data_treat_post.csv",
"data_ctrl_pre.csv"," data_ctrl_post.csv") and have them saved
in the working directory.
}
\examples{
# Run the following codes directly in the console panel. The plots
# generated through the link above may be displaced depending on the screen
# resolution.
one_way_ancova(treat_pre_csv_data =
         system.file("extdata", "data_treat_pre.csv", package = "DBERlibR"),
         treat_post_csv_data =
         system.file("extdata", "data_treat_post.csv", package = "DBERlibR"),
         ctrl_pre_csv_data =
         system.file("extdata", "data_ctrl_pre.csv", package = "DBERlibR"),
         ctrl_post_csv_data =
         system.file("extdata", "data_ctrl_post.csv", package = "DBERlibR"),
         m_cutoff = 0.15)

}
