% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_response.R
\name{variable_response}
\alias{variable_response}
\alias{single_variable}
\title{Marginal Response for a Single Variable}
\usage{
variable_response(explainer, variable, type = "pdp",
  trans = explainer$link, ...)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the 'explain' function}

\item{variable}{character - name of a single variable}

\item{type}{character - type of the response to be calculated.
Currently following options are implemented: 'pdp' for Partial Dependency and 'ale' for Accumulated Local Effects}

\item{trans}{function - a transformation/link function that shall be applied to raw model predictions. This will be inherited from the explainer.}

\item{...}{other parameters}
}
\value{
An object of the class 'svariable_response_explainer'.
It's a data frame with calculated average response.
}
\description{
Calculates the average model response as a function of a single selected variable.
Use the 'type' parameter to select the type of marginal response to be calculated.
Currently for numeric variables we have Partial Dependency and Accumulated Local Effects implemented.
Current implementation uses the 'pdp' package (Brandon M. Greenwell (2017).
pdp: An R Package for Constructing Partial Dependence Plots. The R Journal, 9(1), 421--436.)
and 'ALEPlot' (Dan Apley (2017). ALEPlot: Accumulated Local Effects Plots and Partial Dependence Plots.)
}
\details{
This function is set deprecated. It is suggested to use \code{\link[ingredients]{partial_dependency}}, \code{\link[ingredients]{accumulated_dependency}} instead.
Find information how to use these functions here: \url{https://pbiecek.github.io/PM_VEE/partialDependenceProfiles.html} and \url{https://pbiecek.github.io/PM_VEE/accumulatedLocalProfiles.html}.

For factor variables we are using the 'factorMerger' package.
Please note that the argument \code{type} must be set to \code{'factor'} to use this method.
}
\examples{
HR$evaluation <- factor(HR$evaluation)

HR_glm_model <- glm(status == "fired"~., data = HR, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR)
expl_glm <- variable_response(explainer_glm, "age", "pdp")
plot(expl_glm)

 \dontrun{
library("randomForest")
HR_rf_model <- randomForest(status == "fired" ~., data = HR)
explainer_rf  <- explain(HR_rf_model, data = HR)
expl_rf  <- variable_response(explainer_rf, variable = "age",
                       type = "pdp")
plot(expl_rf)
plot(expl_rf, expl_glm)

# Example for factor variable (with factorMerger)
expl_rf  <- variable_response(explainer_rf, variable =  "evaluation", type = "factor")
plot(expl_rf)

expl_glm  <- variable_response(explainer_glm, variable =  "evaluation", type = "factor")
plot(expl_glm)

# both models
plot(expl_rf, expl_glm)
 }

}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE/}
}
