% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{sensitivity}
\alias{sensitivity}
\title{Runs a sensitivity analysis to test the influences of changing the data
on the parameter estimates for the DAISIE maximum likelihood inference model}
\usage{
sensitivity(
  phylo,
  island_species,
  extraction_method,
  asr_method,
  tie_preference,
  island_age,
  num_mainland_species,
  verbose = FALSE
)
}
\arguments{
\item{phylo}{A phylogeny either as a \code{phylo} (from the \code{ape} package) or
\code{phylo4} (from the \code{phylobase} package) object.}

\item{island_species}{Data frame with two columns. The first is a character
string of the tip_labels with the tip names of the species on the island.
The second column a character string of the endemicity status of the species,
either endemic or nonendemic.}

\item{extraction_method}{A character string specifying whether the
colonisation time extracted is the minimum time (\code{min}) (before the present),
or the most probable time under ancestral state reconstruction (\code{asr}).}

\item{asr_method}{A character string, either "parsimony" or "mk" determines
whether a maximum parsimony or continuous-time markov model reconstructs the
ancestral states at each node. See documentation in
\code{\link[castor:asr_max_parsimony]{castor::asr_max_parsimony()}} or \code{\link[castor:asr_mk_model]{castor::asr_mk_model()}} in \code{castor} R
package for details on the methods used.}

\item{tie_preference}{Character string, either "island" or "mainland" to
choose the most probable state at each node using the \code{max.col()} function.
When a node has island presence and absence equally probable we need to
decide whether that species should be considered on the island. To consider
it on the island use \code{ties.method = "last"} in the \code{max.col()} function, if
you consider it not on the island use \code{ties.method = "first"}. Default is
"island".}

\item{island_age}{Age of the island in appropriate units.}

\item{num_mainland_species}{The size of the mainland pool, i.e. the number
of species that can potentially colonise the island.}

\item{verbose}{Boolean. States if intermediate results should be printed to
console. Defaults to FALSE}
}
\value{
Data frame of parameter estimates and the parameter setting used
when inferring them
}
\description{
Runs a sensitivity analysis to test the influences of changing the data
on the parameter estimates for the DAISIE maximum likelihood inference model
}
