% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_phylod.R
\name{plot_phylod}
\alias{plot_phylod}
\title{Plots the phylogenetic tree and its associated tip and/or node data}
\usage{
plot_phylod(phylod, node_pies = FALSE)
}
\arguments{
\item{phylod}{A `phylo4d` object from the package `phylobase` containing
phylogenetic and endemicity data for each species.}

\item{node_pies}{Boolean determining if pie charts of the probabilities of
a species being present on the island. If TRUE the correct data is required
in the phylod object.}
}
\value{
`ggplot` object
}
\description{
Plots the phylogenetic tree and its associated tip and/or node data
}
\examples{
set.seed(
  1,
  kind = "Mersenne-Twister",
  normal.kind = "Inversion",
  sample.kind = "Rejection"
)
phylo <- ape::rcoal(10)
phylo$tip.label <- c("bird_a", "bird_b", "bird_c", "bird_d", "bird_e",
                     "bird_f", "bird_g", "bird_h", "bird_i", "bird_j")
phylo <- phylobase::phylo4(phylo)
endemicity_status <- sample(
  c("not_present", "endemic", "nonendemic"),
  size = length(phylobase::tipLabels(phylo)),
  replace = TRUE,
  prob = c(0.6, 0.2, 0.2)
)
phylod <- phylobase::phylo4d(phylo, as.data.frame(endemicity_status))
plot_phylod(phylod)
}
