% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D3partitionR.R
\name{D3partitionR}
\alias{D3partitionR}
\title{D3partitionR}
\usage{
D3partitionR(random = F, data = NULL, type = "circleTreeMap",
  tooltipOptions = list(showAbsolutePercent = T, showRelativePercent = T),
  width = 700, height = 700, elementId = NULL, Input = list(enabled = F,
  id = "unique_id", clickedStep = T, currentPath = T, visiblePaths = T,
  visibleLeaf = T, visibleNode = T), title = list(text = NULL, fontSize =
  "auto", no_draw = TRUE), legend = list(no_show = TRUE), trail = FALSE,
  labelStyle = NULL, specificOptions = NULL)
}
\arguments{
\item{random}{generates the selected chart with random values, default to FALSE.}

\item{data}{The inputs data, it should be in one of the following form:\cr 
- a dataframe with two columns, the first one being the paths (and named path) and the second one the value of the paths.\cr 
- a list of two lists with the same properties.}

\item{type}{type of plots, to be among circleTreeMap, partitionChart, treeMap, sunburst, collapsibleIndentedTree, collapsibleTree. Defaut to circleTreeMap.}

\item{tooltipOptions}{list of options for the tooltip:\cr 
- showAbsolutePercent: show the absolute percent from the beginning. Defaut to true.\cr 
- showRelativePercent: show the percent of remaining from the previous step. Defaut to true.}

\item{width}{width of the element.}

\item{height}{height of the element.}

\item{elementId}{Id of the element, default to null.}

\item{Input}{A list of options to use the chart as an input:\cr
- enabled (default to FALSE), set to TRUE to enable the input\cr
- id, the input id to access to the input in shiny\cr
- clickedStep, set to true to get the name of the clicked node\cr
- currentPath (default to TRUE), the path from the root to the clicked node\cr
- visiblePath (default to TRUE), the paths that are currently visble\cr
- visibleNode (default to TRUE), get all visible nodes\cr
- visibleLEaf (default to TRUE), get all visible leafs}

\item{title}{options for the title:\cr 
-text: text to be displayed\cr 
-fontSize: fontSize (ex: "24px")\cr
-style: A CSS string to change the title style ex:"opacity:0;"}

\item{legend}{List of options for the legend:\cr 
- type, the legend can be either categorical or sequential. \cr 
      When setted to categorical, every different step has a different color.\cr 
      When setted to sequential, the steps with a color provided are used as a reference. The further a steps from these reference, the darker.\cr 
- color, Coerce the colors of some steps. Notice: only the colors provided in these are going to be shown in the legend.\cr 
- style: A CSS string to change the legend style ex:"opacity:0;"}

\item{trail}{A boolean to draw or not the sequence trail. Default to false.}

\item{labelStyle}{A CSS string to change the labels style}

\item{specificOptions}{Options speficic to some king of charts\cr 
- collapsibleIndentedTree: list(bar=T), to true if you want to have bars proportional to the size of the step}
}
\description{
This function generates the partition chart from your data or from random data
}
\examples{

#Base bubbleTreeMap with random data
D3partitionR(TRUE)

#sunburst with categorical colors and some coerced legend and color
D3partitionR(TRUE,type="sunburst",
tooltipOptions = list(showAbsolutePercent=FALSE,showRelativePercent=FALSE),
legend=list(type="categorical",color=list("step A"="#0BA","step B"="#AA1","step C"="#ECC")))



}

