% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.TP.R
\name{TP}
\alias{TP}
\title{Computes the True Positive Value.}
\description{
TP is the number of individuals with a positive condition for
which the test result is positive. The value entered here must be non-negative.
}
\seealso{
\code{\link{MeasureFunction}}, \code{\link{ClassificationOutput}},
\code{\link{ConfMatrix}}
}
\keyword{classif}
\keyword{math}
\section{Super class}{
\code{\link[D2MCS:MeasureFunction]{D2MCS::MeasureFunction}} -> \code{TP}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TP-new}{\code{TP$new()}}
\item \href{#method-TP-compute}{\code{TP$compute()}}
\item \href{#method-TP-clone}{\code{TP$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TP-new"></a>}}
\if{latex}{\out{\hypertarget{method-TP-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TP$new(performance.output = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{performance.output}}{An optional \code{\link{ConfMatrix}} parameter
to define the type of object used to compute the measure.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TP-compute"></a>}}
\if{latex}{\out{\hypertarget{method-TP-compute}{}}}
\subsection{Method \code{compute()}}{
The function computes the \strong{TP} achieved by the M.L.
model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TP$compute(performance.output = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{performance.output}}{An optional \code{\link{ConfMatrix}} parameter
to define the type of object used as basis to compute the \strong{TP}
measure.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function is automatically invoke by the
\code{\link{ClassificationOutput}} object.
}

\subsection{Returns}{
A \link{numeric} vector of size 1 or \link{NULL} if
an error occurred.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TP-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TP-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TP$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
