% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.FinalPred.R
\name{FinalPred}
\alias{FinalPred}
\title{Stores the prediction for a specific voting scheme.}
\description{
The class is used to store the computed probability after
executing an specific voting scheme.
}
\seealso{
\code{\link{Prediction}}, \code{\link{SimpleVoting}},
\code{\link{SingleVoting}}, \code{\link{CombinedVoting}},
\code{\link{VotingStrategy}}
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FinalPred$new()}}
\item \href{#method-set}{\code{FinalPred$set()}}
\item \href{#method-getProb}{\code{FinalPred$getProb()}}
\item \href{#method-getRaw}{\code{FinalPred$getRaw()}}
\item \href{#method-getClassValues}{\code{FinalPred$getClassValues()}}
\item \href{#method-getPositiveClass}{\code{FinalPred$getPositiveClass()}}
\item \href{#method-getNegativeClass}{\code{FinalPred$getNegativeClass()}}
\item \href{#method-clone}{\code{FinalPred$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object variables during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FinalPred$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set"></a>}}
\if{latex}{\out{\hypertarget{method-set}{}}}
\subsection{Method \code{set()}}{
Sets the computed probabilities after executing an specific
voting scheme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FinalPred$set(prob, raw, class.values, positive.class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prob}}{A \link{vector} containing the probabilities of the
prediction for a specific voting scheme.}

\item{\code{raw}}{A \link{vector} containing the raw results of the prediction
for a specific voting scheme.}

\item{\code{class.values}}{A \link{vector} containing the class values.}

\item{\code{positive.class}}{A \link{character} value containing the positive
class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getProb"></a>}}
\if{latex}{\out{\hypertarget{method-getProb}{}}}
\subsection{Method \code{getProb()}}{
Gets the probabilities of the prediction for a specific
voting scheme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FinalPred$getProb()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \link{vector} value of probabilities of the prediction for a
specific voting scheme.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getRaw"></a>}}
\if{latex}{\out{\hypertarget{method-getRaw}{}}}
\subsection{Method \code{getRaw()}}{
Gets the raw results of the prediction for a specific voting
scheme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FinalPred$getRaw()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \link{vector} value of raw results of the prediction for a
specific voting scheme.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getClassValues"></a>}}
\if{latex}{\out{\hypertarget{method-getClassValues}{}}}
\subsection{Method \code{getClassValues()}}{
Gets the class values (positive class + negative class).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FinalPred$getClassValues()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \link{vector} value of class values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPositiveClass"></a>}}
\if{latex}{\out{\hypertarget{method-getPositiveClass}{}}}
\subsection{Method \code{getPositiveClass()}}{
Gets the positive class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FinalPred$getPositiveClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \link{character} value of positive class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getNegativeClass"></a>}}
\if{latex}{\out{\hypertarget{method-getNegativeClass}{}}}
\subsection{Method \code{getNegativeClass()}}{
Gets the negative class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FinalPred$getNegativeClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \link{character} value of negative class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FinalPred$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
