% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.utility.DefaultModelFit.R
\name{DefaultModelFit}
\alias{DefaultModelFit}
\title{Default model fitting implementation.}
\description{
Creates a default \code{\link[recipes]{recipe}} and
\code{\link{formula}} objects used in model training stage.
}
\seealso{
\code{\link{GenericModelFit}}, \code{\link[caret]{train}}
}
\keyword{misc}
\section{Super class}{
\code{\link[D2MCS:GenericModelFit]{D2MCS::GenericModelFit}} -> \code{DefaultModelFit}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DefaultModelFit$new()}}
\item \href{#method-createFormula}{\code{DefaultModelFit$createFormula()}}
\item \href{#method-createRecipe}{\code{DefaultModelFit$createRecipe()}}
\item \href{#method-clone}{\code{DefaultModelFit$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultModelFit$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createFormula"></a>}}
\if{latex}{\out{\hypertarget{method-createFormula}{}}}
\subsection{Method \code{createFormula()}}{
The function is responsible of creating a
\code{\link{formula}} for M.L. model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultModelFit$createFormula(instances, class.name, simplify = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instances}}{A \link{data.frame} containing the instances used to
create the recipe.}

\item{\code{class.name}}{A \link{character} vector representing the name of the
target class.}

\item{\code{simplify}}{A \link{logical} argument defining whether the formula
should be generated as simple as possible.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{formula}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createRecipe"></a>}}
\if{latex}{\out{\hypertarget{method-createRecipe}{}}}
\subsection{Method \code{createRecipe()}}{
The function is responsible of creating a
\code{\link[recipes]{recipe}} with five operations over the data:
\code{\link[recipes]{step_zv}}, \code{\link[recipes]{step_nzv}},
\code{\link[recipes]{step_corr}}, \code{\link[recipes]{step_center}},
\code{\link[recipes]{step_scale}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultModelFit$createRecipe(instances, class.name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instances}}{A \code{\link{data.frame}} containing the instances used
to create the recipe.}

\item{\code{class.name}}{A \code{\link{character}} vector representing the name
of the target class.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function is automatically invoked by \code{\link{D2MCS}}
during model training stage.
}

\subsection{Returns}{
An object of class \code{\link[recipes]{recipe}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultModelFit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
