% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcs_files.R
\name{fcs_files}
\alias{fcs_files}
\alias{fcs_files.download,UserSession-method}
\alias{fcs_files.download}
\alias{fcs_files.download_zip,UserSession-method}
\alias{fcs_files.download_zip}
\alias{fcs_files.file_internal_comp_show,UserSession-method}
\alias{fcs_files.file_internal_comp_show}
\alias{fcs_files.list,UserSession-method}
\alias{fcs_files.list}
\alias{fcs_files.show,UserSession-method}
\alias{fcs_files.show}
\alias{fcs_files.upload,UserSession-method}
\alias{fcs_files.upload}
\alias{fcs_files.upload_zip,UserSession-method}
\alias{fcs_files.upload_zip}
\title{FCS File Endpoints}
\usage{
\S4method{fcs_files.download}{UserSession}(
  UserSession,
  experiment_id,
  fcs_file_id,
  directory = getwd(),
  timeout = UserSession@long_timeout
)

\S4method{fcs_files.download_zip}{UserSession}(
  UserSession,
  experiment_id,
  fcs_files,
  directory = getwd(),
  timeout = UserSession@long_timeout
)

\S4method{fcs_files.file_internal_comp_show}{UserSession}(
  UserSession,
  experiment_id,
  fcs_file_id,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{fcs_files.list}{UserSession}(
  UserSession,
  experiment_id,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{fcs_files.show}{UserSession}(
  UserSession,
  experiment_id,
  fcs_file_id,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{fcs_files.upload}{UserSession}(
  UserSession,
  experiment_id,
  file_path,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{fcs_files.upload_zip}{UserSession}(
  UserSession,
  experiment_id,
  file_path,
  output = "default",
  timeout = UserSession@long_timeout
)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{fcs_file_id}{integer representing an FCS file ID}

\item{directory}{character representing a specific directory to which the file will be downloaded (optional ending directory slash), if left empty, the default will be the current working directory \strong{[optional]}}

\item{timeout}{integer representing the request timeout time in seconds \strong{[optional]}}

\item{fcs_files}{vector/list of integers representing a list of FCS file IDs}

\item{output}{character representing the output format \strong{[optional]}\cr
\emph{- fcs_files.file_internal_comp_show : \code{("default", "dataframe", "raw")}}\cr
\emph{- fcs_files.list, fcs_files.show, fcs_files.upload, fcs_files.upload_zip : \code{("default", "raw")}}\cr
\emph{- \code{dataframe}: converts the file internal compensation matrix output to a dataframe}}

\item{file_path}{character representing a file path}
}
\description{
Interact with FCS file endpoints.
}
\details{
\code{fcs_files.download} Download an FCS file from an experiment.

\code{fcs_files.download_zip} Download all or a select set of FCS files as a zip file from an experiment.

\code{fcs_files.file_internal_comp_show} Show FCS file internal compensation (aka spillover matrix, spill matrix, spill string) details from an experiment.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "dataframe", "raw")}}

\code{fcs_files.list} List all FCS files from an experiment. Outputs a dataframe [default] or raw full list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{fcs_files.show} Show FCS file details from an experiment.
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{fcs_files.upload} Upload an FCS file to an experiment.
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{fcs_files.upload_zip} Upload a zip of FCS file(s) to an experiment.
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}
}
\examples{
\dontrun{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\dontrun{# Download an FCS file to the current working directory
fcs_files.download(cyto_session, 22, fcs_file_id=2)

# Download an FCS file to a new directory
fcs_files.download(cyto_session, 22, fcs_file_id=2, directory="/my/new/download/directory/")
}
\dontrun{# Download all files, to the current directory
fcs_files.download_zip(cyto_session, 22)

# Download specific files, to a new directory
fcs_files.download_zip(cyto_session, 22, fcs_files=c(22, 23, 24, 25),
  directory="/my/new/download/directory/")
}
\dontrun{# List of a file internal compensation, containing a file internal compensation matrix
fcs_files.file_internal_comp_show(cyto_session, 22, fcs_file_id=2)

# Dataframe only of a file internal compensation
fcs_files.file_internal_comp_show(cyto_session, 22, fcs_file_id=2, output="dataframe")

# Raw list of a file internal compensation
fcs_files.file_internal_comp_show(cyto_session, 22, fcs_file_id=2, output="raw")
}
\dontrun{# Dataframe of all FCS files with all fields present
fcs_files.list(cyto_session, 22)

# Raw list of all FCS files with all fields present
fcs_files.list(cyto_session, 22, output="raw")
}
\dontrun{fcs_files.show(cyto_session, 22, fcs_file_id=2)
}
\dontrun{fcs_files.upload(cyto_session, 22, file_path="/path/to/my_fcs_file.fcs")
}
\dontrun{fcs_files.upload_zip(cyto_session, 22, file_path="/path/to/my_fcs_files.zip")
}
}
