% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visne.R
\docType{methods}
\name{visne}
\alias{visne}
\alias{visne.copy_settings,UserSession,viSNE-method}
\alias{visne.copy_settings}
\alias{visne.delete,UserSession,viSNE-method}
\alias{visne.delete}
\alias{visne.list,UserSession-method}
\alias{visne.list}
\alias{visne.new,UserSession-method}
\alias{visne.new}
\alias{visne.rename,UserSession,viSNE-method}
\alias{visne.rename}
\alias{visne.run,UserSession,viSNE-method}
\alias{visne.run}
\alias{visne.show,UserSession-method}
\alias{visne.show}
\alias{visne.status,UserSession,viSNE-method}
\alias{visne.status}
\alias{visne.update,UserSession,viSNE-method}
\alias{visne.update}
\alias{visne.helper.set_populations}
\title{viSNE Endpoints}
\usage{
\S4method{visne.copy_settings}{UserSession,viSNE}(UserSession, visne,
  output = "default", timeout = UserSession@short_timeout)

\S4method{visne.delete}{UserSession,viSNE}(UserSession, visne,
  timeout = UserSession@short_timeout)

\S4method{visne.list}{UserSession}(UserSession, experiment_id,
  output = "default", timeout = UserSession@short_timeout)

\S4method{visne.new}{UserSession}(UserSession, experiment_id, visne_name,
  timeout = UserSession@long_timeout)

\S4method{visne.rename}{UserSession,viSNE}(UserSession, visne, visne_name,
  timeout = UserSession@short_timeout)

\S4method{visne.run}{UserSession,viSNE}(UserSession, visne,
  output = "default", timeout = UserSession@long_timeout)

\S4method{visne.show}{UserSession}(UserSession, experiment_id, visne_id,
  timeout = UserSession@short_timeout)

\S4method{visne.status}{UserSession,viSNE}(UserSession, visne,
  output = "default", timeout = UserSession@long_timeout)

\S4method{visne.update}{UserSession,viSNE}(UserSession, visne,
  timeout = UserSession@long_timeout)

visne.helper.set_populations(visne, population_id = NA, fcs_files = NA)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{visne}{Cytobank viSNE object}

\item{output}{character representing the output format  \strong{[optional]}\cr
\emph{- visne.list, visne.run, visne.status : \code{("default", "raw")}}}

\item{timeout}{integer representing the request timeout time in seconds  \strong{[optional]}}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{visne_name}{character representing a new viSNE name}

\item{visne_id}{integer representing a viSNE ID}

\item{population_id}{integer representing a population \strong{gate set ID}}

\item{fcs_files}{vector/list of integers representing a list of FCS file IDs}
}
\description{
Interact with viSNE advanced analyses using these endpoints.
}
\details{
\code{visne.copy_settings} Copy viSNE advanced analysis settings from an experiment and returns a viSNE object.

\code{visne.delete} Delete a viSNE advanced analysis from an experiment.

\code{visne.list} List all viSNE advanced analyses from an experiment. Outputs a dataframe [default] or list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{visne.new} Create a new viSNE advanced analysis from an experiment and returns a viSNE object.

\code{visne.rename} Rename a viSNE advanced analysis from an experiment and returns a viSNE object.

\code{visne.run} Run a viSNE advanced analysis from an experiment.

\code{visne.show} Show viSNE advanced analysis details from an experiment and returns a viSNE object.

\code{visne.status} Show the status of a viSNE advanced analysis from an experiment.

\code{visne.update} Update a viSNE advanced analysis from an experiment and returns the new viSNE object.

\code{visne.helper.set_populations} Set viSNE advanced analysis populations to be selected from an experiment and returns the new viSNE object with the new population selections. The population provided will be overwritten by the newly selected FCS files provided.
}
\examples{
\donttest{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")

# cyto_visne refers to a viSNE object that is created from viSNE endpoints
#   examples: visne.new, visne.show (see details section for more)
}
\donttest{visne.copy_settings(cyto_session, visne=cyto_visne)
}
\donttest{visne.delete(cyto_session, visne=cyto_visne)
}
\donttest{# Dataframe of all viSNE advanced analyses with all fields present
visne.list(cyto_session, 22)

# Raw list of all viSNE advanced analyses with all fields present
visne.list(cyto_session, 22, output="raw")
}
\donttest{visne.new(cyto_session, 22, visne_name="My new viSNE analysis")
}
\donttest{visne.rename(cyto_session, visne=cyto_visne, visne_name="My updated viSNE name")
}
\donttest{visne.run(cyto_session, visne=cyto_visne)
}
\donttest{visne.show(cyto_session, 22, visne_id=2)
}
\donttest{visne.status(cyto_session, visne=cyto_visne)
}
\donttest{visne.update(cyto_session, visne=cyto_visne)
}
\donttest{visne.helper.set_populations(visne=cyto_visne, population_id=1, fcs_files=c(1,2,3))
}
}
