% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attachments.R
\docType{methods}
\name{attachments}
\alias{attachments}
\alias{attachments.delete,UserSession-method}
\alias{attachments.delete}
\alias{attachments.download,UserSession-method}
\alias{attachments.download}
\alias{attachments.download_zip,UserSession-method}
\alias{attachments.download_zip}
\alias{attachments.list,UserSession-method}
\alias{attachments.list}
\alias{attachments.show,UserSession-method}
\alias{attachments.show}
\alias{attachments.update,UserSession-method}
\alias{attachments.update}
\alias{attachments.upload,UserSession-method}
\alias{attachments.upload}
\title{Attachment Endpoints}
\usage{
\S4method{attachments.delete}{UserSession}(UserSession, experiment_id,
  attachment_id, timeout = UserSession@short_timeout)

\S4method{attachments.download}{UserSession}(UserSession, experiment_id,
  attachment_id, directory = getwd(), timeout = UserSession@long_timeout)

\S4method{attachments.download_zip}{UserSession}(UserSession, experiment_id,
  directory = getwd(), timeout = UserSession@long_timeout)

\S4method{attachments.list}{UserSession}(UserSession, experiment_id,
  output = "default", timeout = UserSession@short_timeout)

\S4method{attachments.show}{UserSession}(UserSession, experiment_id,
  attachment_id, output = "default", timeout = UserSession@short_timeout)

\S4method{attachments.update}{UserSession}(UserSession, attachment,
  timeout = UserSession@short_timeout)

\S4method{attachments.upload}{UserSession}(UserSession, experiment_id,
  file_path, output = "default", timeout = UserSession@long_timeout)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{attachment_id}{integer representing an attachment ID}

\item{timeout}{integer representing the request timeout time in seconds  \strong{[optional]}}

\item{directory}{character representing a specific directory to which the file will be downloaded (optional ending directory slash), if left empty, the default will be the current working directory \strong{[optional]}}

\item{output}{character representing the output format  \strong{[optional]}\cr
\emph{- attachments.list, attachments.show, attachments.update : \code{("default", "raw")}}}

\item{attachment}{dataframe representing an attachment (can retrieve via the attachments.show endpoint)}

\item{file_path}{character representing a file path}
}
\description{
Interact with attachments using these endpoints. Only FCS files can be analyzed in Cytobank, but any file can be uploaded as an attachment. Exported PDFs, statistics, and files also automatically attach themselves to the Experiment they are exported from. \href{https://support.cytobank.org/hc/en-us/articles/206145297-Any-type-of-data-can-be-uploaded-and-stored-in-Cytobank}{Learn more about attachments in Cytobank}.
}
\details{
\code{attachments.delete} Permenantly delete an attachment.

\code{attachments.download} Download an attachment from an experiment.

\code{attachments.download_zip} Download all attachments as a zip file from an experiment.

\code{attachments.list} List all attachments from an experiment. Outputs a dataframe [default] or raw list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{attachments.show} Show attachment details from an experiment.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{attachments.update} Update an attachment description from an experiment.

\code{attachments.upload} Upload an attachment to an experiment.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}
}
\examples{
\donttest{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\donttest{attachments.delete(cyto_session, 22, attachment_id=2)
}
\donttest{# Download an attachment to the current working directory
attachments.download(cyto_session, 22, attachment_id=2)

# Download an attachment to a new directory
attachments.download(cyto_session, 22, attachment_id=2, directory="/my/new/download/directory/")
}
\donttest{# Download the attachment zip to the current working directory
attachments.download_zip(cyto_session, 22, attachment_id=2)

# Download the attachment zip to a new directory
attachments.download_zip(cyto_session, 22, attachment_id=2, directory="/my/new/download/directory/")
}
\donttest{# Dataframe of all attachments with all fields present
attachments.list(cyto_session, 22)

# Raw list of all attachments with all fields present
attachments.list(cyto_session, 22, output="raw")
}
\donttest{attachments.show(cyto_session, 22, attachment_id=2)
}
\donttest{attachments.update(cyto_session, attachment=cyto_attachment)
}
\donttest{attachments.upload(cyto_session, 22, file_path="/path/to/my_attachment.txt")
}
}
