% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gates.R
\docType{methods}
\name{gates}
\alias{gates}
\alias{gates.gatingML_download,UserSession-method}
\alias{gates.gatingML_download}
\alias{gates.gatingML_upload,UserSession-method}
\alias{gates.gatingML_upload}
\alias{gates.list,UserSession-method}
\alias{gates.list}
\alias{gates.show,UserSession-method}
\alias{gates.show}
\title{Gate Endpoints}
\usage{
\S4method{gates.gatingML_download}{UserSession}(UserSession, experiment_id,
  directory = getwd(), timeout = UserSession@long_timeout)

\S4method{gates.gatingML_upload}{UserSession}(UserSession, experiment_id,
  file_path, timeout = UserSession@long_timeout)

\S4method{gates.list}{UserSession}(UserSession, experiment_id,
  output = "default", timeout = UserSession@short_timeout)

\S4method{gates.show}{UserSession}(UserSession, experiment_id, gate_id,
  output = "default", timeout = UserSession@short_timeout)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{directory}{character representing a specific directory to which the file will be downloaded (optional ending directory slash), if left empty, the default will be the current working directory \strong{[optional]}}

\item{timeout}{integer representing the request timeout time in seconds \strong{[optional]}}

\item{file_path}{character representing a file path}

\item{output}{character representing the output format \strong{[optional]}\cr
\emph{- gates.list, gates.show : \code{("default", "raw")}}}

\item{gate_id}{integer representing a gate ID}
}
\description{
Interact with gate endpoints. In Cytobank there is a distinction between gates and populations. A gate is simply a shape drawn on a plot. A \link[=populations]{population} is a set of gates and can have parents and children. \href{https://support.cytobank.org/hc/en-us/articles/204765578-The-Difference-Between-a-Gate-and-a-Population-Using-the-Population-Manager-and-considerations-for-deleting-and-renaming-gates}{Learn more about gates and populations}.
Currently gate and population information can only be read and not written to Cytobank via the JSON API. To write gates and populations to Cytobank via the API, the gates.gatingML_upload endpoint should be used.
}
\details{
\code{gates.gatingML_download} Download the gatingML from an experiment. \href{https://support.cytobank.org/hc/en-us/articles/204765618-Exporting-and-Importing-Gates-within-Cytobank-and-with-Gating-ML#gatingml}{Learn more about Gating-ML}.

\code{gates.gatingML_upload} Upload a gatingML to an experiment. \href{https://support.cytobank.org/hc/en-us/articles/204765618-Exporting-and-Importing-Gates-within-Cytobank-and-with-Gating-ML#gatingml}{Learn more about Gating-ML}.

\code{gates.list} List all gates from an experiment. Outputs a dataframe [default] or raw list with all fields present. Currently only the Scratch Gates from the gating interface are returned. These have a version of -1. This is to be contrasted with Experiment Gates, which will have a version number that is a positive integer equal to the number of times the version has been incremented in the gating interface. \href{https://support.cytobank.org/hc/en-us/articles/205399487-The-Apply-and-Apply-and-Return-buttons-and-gate-versioning}{Learn more about gate versioning in Cytobank}.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{gates.show} Show gate details from an experiment.
}
\examples{
\donttest{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\donttest{gates.gatingML_download(cyto_session, 22, directory="/my/new/download/directory/")
}
\donttest{gates.gatingML_upload(cyto_session, 22, file_path="/path/to/my_gatingML.xml")
}
\donttest{# Dataframe of all gates with all fields present
gates.list(cyto_session, 22)

# Raw list of all gates with all fields present
gates.list(cyto_session, 22, output="raw")
}
\donttest{gates.show(cyto_session, 22, gate_id=2)
}
}
