% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectTopFeatures.R
\name{selectTopFeatures}
\alias{selectTopFeatures}
\alias{selectTopFeatures.default}
\alias{selectTopFeatures.Seurat}
\alias{selectTopFeatures.SingleCellExperiment}
\title{Pick top differentially presented features for similarity calculation}
\usage{
selectTopFeatures(x, clusterVar, vertices, ...)

\method{selectTopFeatures}{default}(
  x,
  clusterVar,
  vertices,
  nTop = 30,
  processed = FALSE,
  lfcThresh = 0.1,
  returnStats = FALSE,
  ...
)

\method{selectTopFeatures}{Seurat}(
  x,
  clusterVar = NULL,
  vertices,
  assay = NULL,
  layer = "counts",
  processed = FALSE,
  ...
)

\method{selectTopFeatures}{SingleCellExperiment}(
  x,
  clusterVar = NULL,
  vertices,
  assay.type = "counts",
  processed = FALSE,
  ...
)
}
\arguments{
\item{x}{Dense or sparse matrix, observation per column. Preferrably a raw
count matrix. Alternatively, a \code{Seurat} object or a
\code{SingleCellExperiment} object.}

\item{clusterVar}{A vector/factor assigning the cluster variable to each
column of the matrix object. For "Seurat" method, \code{NULL} (default) for
\code{Idents(x)}, or a variable name in \code{meta.data} slot. For
"SingleCellExperiment" method, \code{NULL} (default) for \code{colLabels(x)},
or a variable name in \code{colData} slot.}

\item{vertices}{Vector of cluster names that will be used for plotting. Or a
named list that groups clusters as a terminal vertex. There must not be any
overlap between groups.}

\item{...}{Arguments passed to methods.}

\item{nTop}{Number of top differentially presented features per terminal.
Default \code{30}.}

\item{processed}{Logical. Whether the input matrix is already processed.
\code{TRUE} will bypass internal preprocessing and input matrix will be
directly used for rank-sum calculation. Default \code{FALSE} and raw count
input is recommended.}

\item{lfcThresh}{Threshold on log fold-change to identify up-regulated
features. Default \code{0.1}.}

\item{returnStats}{Logical. Whether to return the full statistics table
rather then returning the selected genes. Default \code{FALSE}}

\item{assay}{Assay name of the Seurat object to be used. Default \code{NULL}.}

\item{layer}{For "Seurat" method, which layer of the assay to be used.
Default \code{"counts"}.}

\item{assay.type}{Assay name of the SingleCellExperiment object to be used.
Default \code{"counts"}.}
}
\value{
When \code{returnStats = FALSE} (default), a character vector of at
most \code{length(unique(vertices))*nTop} feature names. When
\code{returnStats = TRUE}, a data.frame of wilcoxon rank sum test statistics.
}
\description{
Performs wilcoxon rank-sum test on input matrix. While \code{clusterVar} and
\code{vertices} together defines the groups of cells to be set as terminals
of the simplex, this function will test each of these groups against the rest
of the cells. The U-Statistics (\code{statistic}), p-value (\code{pval}) and
adjusted p-value (\code{padj}), together with average presence in group
(\code{avgExpr}), log fold-change (\code{logFC}), AUC (\code{auc}),
percentage in group (\code{pct_in}) and percentage out of group
(\code{pct_out}) will be calculated. Set \code{returnStats = TRUE} to return
the full statistics table.

Top features are selected by sorting primarily on adjusted p-value, and
secondarily on log fold-change, after filtering for up-regulated features.
}
\examples{
selectTopFeatures(rnaRaw, rnaCluster, c("OS", "RE"))
\donttest{
# Seurat example
library(Seurat)
srt <- CreateSeuratObject(rnaRaw)
Idents(srt) <- rnaCluster
gene <- selectTopFeatures(srt, vertices = c("OS", "RE"))
}
\donttest{
# SingleCellExperiment example
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(counts = rnaRaw))
colLabels(sce) <- rnaCluster
gene <- selectTopFeatures(sce, vertices = c("OS", "RE"))
}
}
