% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFit.R
\name{getCyclopsProfileLogLikelihood}
\alias{getCyclopsProfileLogLikelihood}
\title{Profile likelihood for Cyclops model parameters}
\usage{
getCyclopsProfileLogLikelihood(
  object,
  parm,
  x = NULL,
  bounds = NULL,
  tolerance = 0.001,
  initialGridSize = 10,
  includePenalty = TRUE
)
}
\arguments{
\item{object}{Fitted Cyclops model object}

\item{parm}{Specification of which parameter requires profiling,
either a vector of numbers of covariateId names}

\item{x}{Vector of values of the parameter}

\item{bounds}{Pair of values to bound adaptive profiling}

\item{tolerance}{Absolute tolerance allowed for adaptive profiling}

\item{initialGridSize}{Initial grid size for adaptive profiling}

\item{includePenalty}{Logical: Include regularized covariate penalty in profile}
}
\value{
A data frame containing the profile log likelihood. Returns NULL when the adaptive profiling fails
to converge.
}
\description{
\code{getCyclopsProfileLogLikelihood} evaluates the profile likelihood at a grid of parameter values.
}
