% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrMat.R
\name{contrMat2}
\alias{contrMat2}
\title{Create the design matrix, variance-covariance matrix, the variance of each
pairwise comparison and the efficicency of each pairwise comparison for a
cross-over design}
\usage{
contrMat2(
  type,
  v,
  model,
  eff.factor = rep(1, length(parameterCount(model, v)))
)
}
\arguments{
\item{type}{Type of contrast. A character vector containing the following: "Dunnett", "Tukey", "none".
If the length is 1, this contrast is only applied for the treatment effects and for carry-over effects a "Tukey" contrast is used.
Otherwise the specified contrasts are used, see also the examples.}

\item{v}{Number of treatments}

\item{model}{Model - one of the following: 1) "Standard additive model",
2) "Second-order carry-over effects", 3) "Full set of interactions",
4) "Self-adjacency model", 5) "Placebo model", 6) "No carry-over into self
model", 7) "Treatment decay model", 8) "Proportionality model", 9) "No carry-over effects". 
Can be specified as number or as character string.}

\item{eff.factor}{Weight applied to the different sub contrast matrices. A warning is given if it does not sum up to one. See examples.}
}
\value{
A contrast matrix
}
\description{
Function to read in a cross-over design and create the design matrix X, 
the variance of each pairwise comparison and the efficicency of each pairwise comparison.
}
\details{
See the vignette of this package for further details.
}
\examples{

contrMat2("Tukey", v=3, model=1)
contrMat2("Dunnett", v=3, model=1)
contrMat2(c("Dunnett", "Dunnett"), v=3, model=1)
contrMat2(c("Dunnett", "none"), v=3, model=1)
contrMat2(c("Dunnett", "none", "none"), v=3, model=8)
contrMat2("Dunnett", v=3, model=1, eff.factor=c(0.9, 0.1))
contrMat2("Dunnett", v=3, model=8, eff.factor=c(0.5, 0.3, 0.2))

}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}
\keyword{misc}
