/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.af.commons.io.FileTools;
import org.mutoss.config.ClassConfig;
import org.mutoss.config.Configuration;
import org.mutoss.gui.CrossoverGUI;
import org.mutoss.gui.Design;
import org.mutoss.gui.RControl;

public class DesignInputPanel
extends JPanel
implements KeyListener,
ActionListener {
    JTextField jtTitle = new JTextField();
    JTextField jtReference = new JTextField();
    JButton ok = new JButton("Ready");
    JButton loadFile = new JButton("Load File");
    JButton loadRObject = new JButton("Load from R");
    JButton save = new JButton("Save to my archive of designs");
    JTextArea jta;
    JLabel label = new JLabel();
    JComboBox jcbRows = new JComboBox<String>(new String[]{"periods", "sequences"});
    CrossoverGUI gui;
    ClassConfig ac = new ClassConfig(Configuration.getInstance(), DesignInputPanel.class);

    public DesignInputPanel(CrossoverGUI gui) {
        this.gui = gui;
        String cols = "5dlu, fill:min:grow, 5dlu, fill:min:grow, 5dlu,";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        layout.setColumnGroups((int[][])new int[][]{{2, 4}});
        this.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.add((Component)new JLabel("Please enter your design here:"), cc.xy(2, row));
        this.add((Component)new JLabel(""), cc.xy(4, row));
        row += 2;
        this.jta = new JTextArea("");
        this.jta.setFont(new Font("Monospaced", 0, 12));
        this.jta.setLineWrap(false);
        this.jta.setMargin(new Insets(4, 4, 4, 4));
        this.jta.addKeyListener(this);
        this.add((Component)new JScrollPane(this.jta), cc.xy(2, row));
        this.add((Component)new JScrollPane(this.getRightSidePanel()), cc.xy(4, row));
        this.loadFile.addActionListener(this);
        this.add((Component)this.loadFile, cc.xy(2, row += 2));
        this.save.addActionListener(this);
        this.add((Component)this.save, cc.xy(4, row));
        this.loadDefaults();
    }

    public JPanel getRightSidePanel() {
        JPanel panel = new JPanel();
        String cols = "5dlu, pref, 5dlu, fill:min:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        panel.add((Component)new JLabel("Title"), cc.xy(2, row));
        panel.add((Component)this.jtTitle, cc.xy(4, row));
        panel.add((Component)new JLabel("Reference"), cc.xy(2, row += 2));
        panel.add((Component)this.jtReference, cc.xy(4, row));
        this.jcbRows.addActionListener(this);
        panel.add((Component)new JLabel("Rows represent"), cc.xy(2, row += 2));
        panel.add((Component)this.jcbRows, cc.xy(4, row));
        panel.add((Component)this.label, cc.xyw(2, row += 2, 3));
        return panel;
    }

    public void loadDefaults() {
        this.jcbRows.setSelectedIndex(this.ac.getIntProperty("CVPattern", 0));
    }

    public void saveDefaults() {
        this.ac.setIntProperty("CVPattern", this.jcbRows.getSelectedIndex());
    }

    public boolean transpose() {
        return !this.jcbRows.getSelectedItem().equals("periods");
    }

    public void addActionListener(ActionListener al) {
        this.ok.addActionListener(al);
    }

    public Design getDesign() {
        return null;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.checkDesign();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        this.saveDefaults();
        if (e.getSource() == this.loadFile) {
            JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "DesignDirectory"));
            fc.setFileSelectionMode(0);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File f = fc.getSelectedFile();
                Configuration.getInstance().setClassProperty(this.getClass(), "DesignDirectory", f.getParent());
                try {
                    String text = FileTools.readFileAsString((File)f);
                    this.jta.setText(text);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(this, "File could not be opened:\n" + e1.getMessage(), "Error opening file", 0);
                }
            }
        } else if (e.getSource() == this.jcbRows) {
            this.checkDesign();
        } else if (e.getSource() == this.save) {
            try {
                this.saveDesign();
                this.gui.dac.addEnteredDesign(new Design(this.jtTitle.getText(), ".newDesign", this.jtReference.getText()));
            }
            catch (Exception error) {
                JOptionPane.showMessageDialog(this, "Design not valid.\nPlease correct.", "Design not valid", 0);
            }
        }
    }

    private void saveDesign() throws Exception {
        String input = this.jta.getText();
        RControl.getR().evalVoid(".con <- textConnection(\"" + input + "\")");
        RControl.getR().eval(".newDesign <- try(as.matrix(read.table(.con, header = FALSE)), silent=TRUE)");
        if (this.transpose()) {
            RControl.getR().eval(".newDesign <- t(.newDesign)");
        }
        if (RControl.getR().eval("(\"try-error\" %in% class(.newDesign))").asRLogical().getData()[0]) {
            throw new Exception();
        }
    }

    private void checkDesign() {
        try {
            this.saveDesign();
            int[] dim = RControl.getR().eval("dim(.newDesign)").asRInteger().getData();
            int t = RControl.getR().eval("length(levels(as.factor(.newDesign)))").asRInteger().getData()[0];
            this.label.setText("p = " + dim[0] + ", s = " + dim[1] + ", t = " + t);
        }
        catch (Exception error) {
            this.label.setText("Design is not valid, please correct it.");
        }
    }
}

