% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCarry.R
\name{createCarry}
\alias{createCarry}
\title{Add carryover dummy variables}
\usage{
createCarry(data, treatment, period, id, carrySimple = TRUE)
}
\arguments{
\item{data}{A data frame with the variables of
the crossover experimental design}

\item{treatment}{A character string specifying the name of vector with the
treatment applied at each observation of the crossover experimental design}

\item{period}{A character string specifying the name of vector with the
observation period of the responses of  the crossover experimental design}

\item{id}{A  character string specifying the name of vector which identifies
the experimental units.}

\item{carrySimple}{\code{TRUE} = simple carry-over, where the residual effect of a
treatment affects equally each of the treatments that are preceded by it,
 and \code{FALSE} = carry-over complex, where the residual effect of the
  treatment affects each of the other treatments differently.}
}
\value{
\code{data} A data frame with all the variables of
the crossover experimental design and the carryover variables

\code{carryover} The new carryover variables
}
\description{
Create dummy variables associated with first-order
carryover effect in a Crossover Design
}
\examples{
data(Water)
carryover <- createCarry(data=Water,
                         treatment = "Treatment", id = "ID",
                         period = "Period", carrySimple = FALSE)
carryover$carryover
carryover$data
}
