% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiagTest1.2015Lan.R
\name{DiagTest1.2015Lan}
\alias{DiagTest1.2015Lan}
\title{One-Sample Diagonality Test by Lan et al. (2015)}
\usage{
DiagTest1.2015Lan(data, alpha = 0.05)
}
\arguments{
\item{data}{an \eqn{(n\times p)} data matrix where each row is an observation.}

\item{alpha}{level of significance.}
}
\value{
a named list containing: \describe{
\item{statistic}{a test statistic value.}
\item{threshold}{rejection criterion to be compared against test statistic.}
\item{reject}{a logical; \code{TRUE} to reject null hypothesis, \code{FALSE} otherwise.}
}
}
\description{
Given data, it performs 1-sample test for diagonal entries of a Covariance matrix where
the null hypothesis is
\deqn{H_0 : \sigma_{ij} = 0~\mathrm{for any}~i \neq j}
and alternative hypothesis is \eqn{H_1 : ~\mathrm{not}~H_0}
with \eqn{\Sigma_n = (\sigma_{ij})} based on a procedure proposed by Lan et al. (2015).
}
\examples{
\dontrun{
## generate data from multivariate normal with trivial covariance.
data = matrix(rnorm(100*5), nrow=100)

## run test with different alpha values
DiagTest1.2015Lan(data, alpha=0.01)
DiagTest1.2015Lan(data, alpha=0.05)
DiagTest1.2015Lan(data, alpha=0.10)
}

}
\references{
\insertRef{lan_testing_2015}{CovTools}
}
