% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Renewal_cstr.R
\name{renewal}
\alias{renewal}
\title{Fit renewal count processes regression models}
\usage{
renewal(formula, data, subset, na.action, weights, offset, dist = c("custom",
  "weibull", "weibullgam", "gamma", "gengamma", "burr"), anc = NULL,
  convPars = NULL, link = NULL, time = 1,
  control = renewal.control(...), customPars = NULL, seriesPars = NULL,
  weiMethod = NULL, computeHessian = TRUE, model = TRUE, y = TRUE,
  x = FALSE, ...)
}
\arguments{
\item{formula}{single response formula object.}

\item{data, subset, na.action, }{arguments controlling formula processing
via \code{model.frame}.}

\item{weights}{optional numeric vector of weights.}

\item{offset}{optional numeric vector with an a priori known component
to be included in the linear predictor of the count model. Currently
not used.}

\item{dist}{character built-in distribution to be used for the inter-
arrival time distribution. Currently built in distribution are \code{weibull},
\code{weibullgam}, \code{gamma}, \code{gengamma} (generalized-gamma)
and \code{burr}. User can provide his own distribution
by setting \code{dist} to \code{custom}.}

\item{anc}{list (named) of formulae to model regression on ancillary
parameters. If \code{NULL}, no regression is modelled. Otherwise, the
formulae associated with the (exact) parameter name is used.}

\item{convPars}{a list of convolution parameters argumentswith slots
\code{nsteps}, \code{extrap} and \code{convMethod}.
See \code{dCount_conv_bi}. If NULL, default parameters will be applied.}

\item{link}{list (named) of character specifiying the name of the link function
to be used in the regression. If \code{NULL}, the canonical
link function will be used, i.e, \code{log} if the parameter is supposed
to be positive, identity otherwise.}

\item{time}{numeric time at which the count is observed; default to unit (1)}

\item{control}{a list of control arguments specified via
\code{renewal.control}.}

\item{customPars}{list user inputs if \code{dist = "custom"}. See details}

\item{seriesPars}{list series expansion input parameters with slots
\code{terms} (number of terms in the series expansion),
\code{iter} (number of iteration in the accelerated series expansion
algorithm) and \code{eps} (tolerance in the accelerated series expansion
algorithm), Only used if \code{dist = "weibull"} and
\code{weiMethod = c("series_mat", "series_acc")}.}

\item{weiMethod}{character computation method to be used if
\code{dist = c("weibull", "weibullgam")}. See \code{dWeibullCount} and
\code{dWeibullgammaCount}.}

\item{computeHessian}{logical should the hessian (and hence the covariance
matrix) be computed numerically at the fitted values.}

\item{model, y, x}{logicals. If \code{TRUE} the  corresponding  components
of  the  fit  (model  frame,  response, model matrix) are returned.}

\item{...}{arguments passed to \code{renewal.control} in the default setup.}
}
\value{
An \code{S3} object of class "renewal", i.e., a list with components
including:
\describe{
\item{coefficients}{value of the fitted coefficients}
\item{residuals}{vector of weighted residuals \eqn{\omega * (observed - fitted)}}
\item{fitted.values}{vector of fitted means}
\item{optim}{data.frame output of \code{optimx}}
\item{method}{optimisation algorithm}
\item{control}{the control arguments passed to \code{optimx}}
\item{start}{starting values  passed to \code{optimx}}
\item{weights}{weights applied if any}
\item{n}{number of observation (with weights > 0)}
\item{iterations}{number of iterations in the optimisation algorithm}
\item{execTime}{duration of the optimisation}
\item{loglik}{log-likelihood of the fitted model}
\item{df.residual}{residuals degrees of freedom for the fitted model}
\item{vcoc}{convariance matrix of all coefficients computed numerically from the
hessian at the fitted coefficients (if \code{computeHessian} ois \code{TRUE}).}
\item{dist}{name of inter-arrival distribution.}
\item{link}{list inverse link function corresponding to each parameter in the
inter-arrival distribution}
\item{converged}{logical did the optimisation algorithm converged ?}
\item{data}{data used to fit the model}
\item{formula}{the original formula}
\item{call}{the original function call}
\item{anc}{list (named) of formulae to model regression on ancillary
parameters.}
\item{convPars}{convolution inputs used}
\item{customPars}{user passed distribution inputs. See details}
\item{time}{observed window used. default to 1.0 (see inputs)}
\item{model}{the full model frame (if \code{model = TRUE}}
\item{y}{the response count vector (if \code{y = TRUE}}
\item{x}{the model matrix if \code{x = TRUE}}
}
}
\description{
Fit renewal regression models for count data via maximum likelihood.
}
\details{
\code{renewal} re-uses design and functionality of the basic R tools
for fitting regression model (\code{lm}, \code{glm}) and is highly
inspired from \code{hurdle()} and \code{zeroinfl()} from package
\code{pscl}. Package \code{Formula} was used to handle formulae.

If User wants to pass his own inter-arrival
distribution i.e, \code{dist = "custom"}, he needs to provides his own
initial values as well as the \code{customPars} list as follows:
\describe{
\item{parNames}{character vector the distribution parameters name.
Location parameter should be passed first.}
\item{survivalFct}{function object containing the survival function. It
should have the signature \code{function(t, distPars)} where $t$ is the
point where the survival function is evaluated and distPars is the list
of the distribution parameters. It should return a double value.}
\item{extrapolFct}{function object computing the extrapolation values
(numeric of length 2) from the value of the distribution parameters
(in \code{distPars}). It should have the signature
\code{function(distPars)} and returns a numeric vector of length 2. Only
required if the extrapolation is set to \code{TRUE} in \code{convPars}.}
}
Some checks will be used to validate the \code{customPars} input but
it is user responsability to make sure the different functions have the
appropriate signatures.
\strong{Note:} The weibull gamma is an experimental version and user should
use it with care! It is very sensitive to initials values and there is no
guarantee of convergence. It has also been reparametrized in terms of
(1/r, 1/alpha, c) instead of (r, alpha, c) where r and alpha are the
shape and scale of the gamma distribution and c is the shape of the
weibull distribution.
}

