% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBData.R, R/CMData.R
\name{Extract}
\alias{Extract}
\alias{[.CBData}
\alias{[.CMData}
\title{Extract from a CBData or CMData object}
\usage{
\method{[}{CBData}(x, i, j, drop)

\method{[}{CMData}(x, i, j, drop)
}
\arguments{
\item{x}{\code{CMData} object.}

\item{i}{numeric, row index of extracted values}

\item{j}{numeric, column index of extracted values}

\item{drop}{logical. If TRUE the result is coerced to the lowest possible dimension. 
The default is the same as for \code{\link{[.data.frame}}: to drop if only one column is left, but not to drop if only one row is left.}
}
\value{
a \code{CBData} or \code{CMData} object
}
\description{
The extracting syntax works as for \code{\link{[.data.frame}}, and in general the returned object is not a \code{CBData} or \code{CMData} object.
However if the columns are not modified, then the result is still a \code{CBData} or \code{CMData} object  with appropriate attributes  preserved, 
and the unused levels of treatment groups dropped.
}
\examples{

data(shelltox)
str(shelltox[1:5,])
str(shelltox[1:5, 2:4])

data(dehp)
str(dehp[1:5,])
str(dehp[1:5, 2:4])
}
\seealso{
\code{CBData}, \code{\link{CMData}}
}
\author{
Aniko Szabo
}
\keyword{manip}
