% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hist.R
\name{Hist}
\alias{Hist}
\title{Histograms with clusters}
\usage{
Hist(
  x,
  classes = NULL,
  plot = TRUE,
  col = 2:10,
  mode = c("classical", "cumsum", "density"),
  breaks = "Sturges",
  ...
)
}
\arguments{
\item{x}{a vector, matrix or data.frame on which the histogram will be computed and ploted.}

\item{classes}{vector of classes to color}

\item{plot}{if FALSE, the histogram is only computed with no graphical output.}

\item{col}{numeric color}

\item{mode}{one of c("classical","cumsum","density")}

\item{breaks}{by default: "Sturges"}

\item{...}{further arguments and graphical parameters passed to plot.histogram and thence to title and axis.}
}
\description{
Histograms with clusters
}
\examples{
x <- c(rnorm(50, 0, 1), rnorm(50, 1, 1))
classes <- rep(1:2, each = 50)
Hist(x, classes)

}
