% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMID.R
\name{getMID}
\alias{getMID}
\title{getMID.}
\usage{
getMID(
  fml,
  resolution = 20000,
  cutoff = 1e-04,
  isotopes = NULL,
  prec = 4,
  step = 0
)
}
\arguments{
\item{fml}{Chemical formula.}

\item{resolution}{Currently fixed to 20000 (might be made changable in the future).}

\item{cutoff}{Discard peaks below this threshold (relative to highest peak).}

\item{isotopes}{Specify explicitly or keep NULL to use internally provided list.}

\item{prec}{Rounding precision of returned mz and int values.}

\item{step}{Can be used to return intermediate results (might be deprecated in the future).}
}
\value{
A two column matrix for mz and int values of the calculated spectrum.
}
\description{
\code{getMID} will determine the measurable isotopic
   spectrum for a chemical formula.
}
\details{
The computation yields similar results that would be obtained by
   packages `Rdisop` or `enviPat` but is completely in R (no C++ dependencies).
   However, it is approx. 7-fold slower than `Rdisop`. Where processing speed
   is of importance, please use the `algo` parameter of the `CorMID` function.
}
\examples{
fml <- "C3H7Cl1"
getMID(fml)
\dontrun{
bench::mark(
 CorMID = dim(getMID(fml, prec=5)),
 Rdisop = dim(round(t(Rdisop::getMolecule(fml)$isotopes[[1]])[1:4,],5))
)
}

\dontrun{
data(chemforms, package = "enviPat")
chemforms <- chemforms[-grep("[[]", chemforms)]
bench::mark(
 CorMID = length(lapply(chemforms, getMID)),
 Rdisop = length(lapply(chemforms, Rdisop::getMolecule))
)
}
}
