% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_val.R
\name{cc_val}
\alias{cc_val}
\title{Identify Invalid lat/lon Coordinates}
\usage{
cc_val(
  x,
  lon = "decimalLongitude",
  lat = "decimalLatitude",
  value = "clean",
  verbose = TRUE
)
}
\arguments{
\item{x}{data.frame. Containing geographical coordinates and species names.}

\item{lon}{character string. The column with the longitude coordinates.
Default = \dQuote{decimalLongitude}.}

\item{lat}{character string. The column with the latitude coordinates.
Default = \dQuote{decimalLatitude}.}

\item{value}{character string.  Defining the output value. See value.}

\item{verbose}{logical. If TRUE reports the name of the test and the number
of records flagged.}
}
\value{
Depending on the \sQuote{value} argument, either a \code{data.frame}
  containing the records considered correct by the test (\dQuote{clean}) or a
  logical vector (\dQuote{flagged}), with TRUE = test passed and FALSE = test
  failed/potentially problematic . Default = \dQuote{clean}.
}
\description{
Removes or flags non-numeric and not available coordinates
as well as lat >90, lat <-90, lon > 180 and lon < -180 are flagged.
}
\details{
This test is obligatory before running any further tests of
CoordinateCleaner, as additional tests only run with valid coordinates.
}
\note{
See \url{https://ropensci.github.io/CoordinateCleaner/} for more
details and tutorials.
}
\examples{

x <- data.frame(species = letters[1:10], 
                decimalLongitude = c(runif(106, -180, 180), NA, "13W33'", "67,09", 305), 
                decimalLatitude = runif(110, -90,90))
                
cc_val(x)
cc_val(x, value = "flagged")

}
\seealso{
Other Coordinates: 
\code{\link{cc_aohi}()},
\code{\link{cc_cap}()},
\code{\link{cc_cen}()},
\code{\link{cc_coun}()},
\code{\link{cc_dupl}()},
\code{\link{cc_equ}()},
\code{\link{cc_gbif}()},
\code{\link{cc_inst}()},
\code{\link{cc_iucn}()},
\code{\link{cc_outl}()},
\code{\link{cc_sea}()},
\code{\link{cc_urb}()},
\code{\link{cc_zero}()}
}
\concept{Coordinates}
\keyword{Coordinate}
\keyword{cleaning}
