% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_sea.R
\name{cc_sea}
\alias{cc_sea}
\title{Identify Non-terrestrial Coordinates}
\usage{
cc_sea(
  x,
  lon = "decimallongitude",
  lat = "decimallatitude",
  ref = NULL,
  scale = 110,
  value = "clean",
  speedup = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{data.frame. Containing geographical coordinates and species
names.}

\item{lon}{character string. The column with the longitude coordinates.
Default = \dQuote{decimallongitude}.}

\item{lat}{character string. The column with the latitude coordinates.
Default = \dQuote{decimallatitude}.}

\item{ref}{a SpatialPolygonsDataFrame. Providing the geographic gazetteer.
Can be any SpatialPolygonsDataFrame, but the structure must be identical to
rnaturalearth::ne_download(scale = 110, type = 'land', category = 'physical').  
Default = rnaturalearth::ne_download(scale = 110, type = 'land', category = 'physical')}

\item{scale}{the scale of the default reference, as downloaded from natural earth. 
Must be one of 10, 50, 110. Higher numbers equal higher detail. Default = 110.}

\item{value}{character string.  Defining the output value. See value.}

\item{speedup}{logical. Using heuristic to speed up the analysis for large data sets
with many records per location.}

\item{verbose}{logical. If TRUE reports the name of the test and the number
of records flagged.}
}
\value{
Depending on the \sQuote{value} argument, either a \code{data.frame}
containing the records considered correct by the test (\dQuote{clean}) or a
logical vector (\dQuote{flagged}), with TRUE = test passed and FALSE = test failed/potentially
problematic . Default = \dQuote{clean}.
}
\description{
Removes or flags coordinates outside the reference landmass. Can be used to restrict
datasets to terrestrial taxa, or exclude records from the open ocean, when
depending on the reference (see details). Often records of terrestrial taxa
can be found in the open ocean, mostly due to switched latitude and
longitude.
}
\details{
In some cases flagging records close of the coastline is not recommendable,
because of the low precision of the reference dataset, minor GPS imprecision
or because a dataset might include coast or marshland species. If you only
want to flag records in the open ocean, consider using a buffered landmass
reference, e.g.: \code{\link{buffland}}.
}
\note{
See \url{https://ropensci.github.io/CoordinateCleaner/} for more
details and tutorials.
}
\examples{
x <- data.frame(species = letters[1:10], 
                decimallongitude = runif(10, -30, 30), 
                decimallatitude = runif(10, -30, 30))
                
cc_sea(x, value = "flagged")

}
\seealso{
Other Coordinates: 
\code{\link{cc_cap}()},
\code{\link{cc_cen}()},
\code{\link{cc_coun}()},
\code{\link{cc_dupl}()},
\code{\link{cc_equ}()},
\code{\link{cc_gbif}()},
\code{\link{cc_inst}()},
\code{\link{cc_iucn}()},
\code{\link{cc_outl}()},
\code{\link{cc_urb}()},
\code{\link{cc_val}()},
\code{\link{cc_zero}()}
}
\concept{Coordinates}
\keyword{Coordinate}
\keyword{cleaning}
