% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NucleolusDerivatives.R
\name{simplifiedModiclus}
\alias{simplifiedModiclus}
\title{Compute simplified modiclus}
\usage{
simplifiedModiclus(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Numeric vector of length n representing the simplified modiclus 
of the specified TU game.
}
\description{
Computes the simplified modiclus of a TU game with a non-empty imputation set and n players.
}
\examples{
library(CoopGame)
simplifiedModiclus(c(0, 0, 0, 1, 1, 0, 1))

\donttest{
#Second example:
#Estate division problem from Babylonian Talmud with E=100,
#see e.g. seminal paper by Aumann & Maschler from 1985 on
#'Game Theoretic Analysis of a Bankruptcy Problem from the Talmud'
library(CoopGame)
v<-bankruptcyGameVector(n=3,d=c(100,200,300),E=100)
simplifiedModiclus(v)
#[1]  33.33333 33.33333 33.33333
}

}
\references{
Tarashnina S. (2011) "The simplified modified nucleolus of a cooperative TU-game", TOP 19(1), pp. 150--166
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
