% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertyAdditivity.R
\name{isAdditiveGame}
\alias{isAdditiveGame}
\title{Check if game is additive}
\usage{
isAdditiveGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is additive, else \code{FALSE}
}
\description{
Checks if a TU game with n players is additive. \cr
In an additive game for any two disjoint coalitions 
\code{S} and \code{T} the value of the union of 
\code{S} and \code{T} equals the sum of the values  
of \code{S} and \code{T}. In other words, additive games 
are constant-sum and the imputation set of an 
additive game consists of exactly one point.
}
\examples{
library(CoopGame)
isAdditiveGame(c(1,1,1,2,2,2,3))

\donttest{
#The following game is not additive
library(CoopGame)
v=c(0,0,0,40,50,20,100)
isAdditiveGame(v) 

#The following game is additive
library(CoopGame)
v=c(1,1,1,1, 2,2,2,2,2,2, 3,3,3,3, 4)
isAdditiveGame(v)
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 11

Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, p. 292

Osborne M.J. and Rubinstein A. (1994) \emph{A Course in Game Theory}, MIT Press, p. 261
}
\author{
Alexandra Tiukkel

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
