% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BanzhafConcept.R
\name{drawNormalizedBanzhafIndex}
\alias{drawNormalizedBanzhafIndex}
\title{draw normalized Banzhaf Index for 3 or 4 players}
\usage{
drawNormalizedBanzhafIndex(v, holdOn = FALSE, colour = NA,
  label = TRUE, name = "Normalized Banzhaf index")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawNormalizedBanzhafIndex draws the Banzhaf Value for 3 or 4 players. \cr
             Drawing any kind of Banzhaf values only makes sense from our point of view 
             for the normalized Banzhaf index for simple games, because 
             only in this case will the Banzhaf index be efficient.
}
\examples{
library(CoopGame)
v<-weightedVotingGameVector(n=3,w=c(50,30,20),q=c(67))
drawNormalizedBanzhafIndex(v)

}
\references{
Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 367--370

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 118--119

Bertini C. and Stach I. (2011) "Banzhaf voting power measure", Encyclopedia of Power, SAGE Publications, pp. 54--55
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
