% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MinimumConnectednessPortfolio.R
\name{MinimumConnectednessPortfolio}
\alias{MinimumConnectednessPortfolio}
\title{Minimum connectedness portfolio}
\usage{
MinimumConnectednessPortfolio(
  x,
  H,
  method = c("cumsum", "cumprod"),
  statistics = c("Fisher", "Bartlett", "Fligner-Killeen", "Levene", "Brown-Forsythe"),
  long = TRUE,
  digit = 2
)
}
\arguments{
\item{x}{zoo return matrix (in percentage)}

\item{H}{Pairwise connectedness matrix or alternatively variance-covariance or correlation matrix}

\item{method}{Cumulative sum or cumulative product}

\item{statistics}{Hedging effectiveness statistic}

\item{long}{Allow only long portfolio position}

\item{digit}{Number of decimal places}
}
\value{
Get portfolio weights
}
\description{
This function calculates the minimum connectedness portfolio
}
\examples{
data("g2020")
fit = VAR(g2020, configuration=list(nlag=1))
dca = TimeConnectedness(Phi=fit$B, Sigma=fit$Q, nfore=10, generalized=TRUE)
mcp = MinimumConnectednessPortfolio(g2020, dca$PCI, statistics="Fisher")
mcp$TABLE
}
\references{
Broadstock, D. C., Chatziantoniou, I., & Gabauer, D. (2022). Minimum connectedness portfolios and the market for green bonds: Advocating socially responsible investment (SRI) activity. In Applications in Energy Finance (pp. 217-253). Palgrave Macmillan, Cham.

Ederington, L. H. (1979). The hedging performance of the new futures markets. The Journal of Finance, 34(1), 157-170.

Antonakakis, N., Cunado, J., Filis, G., Gabauer, D., & de Gracia, F. P. (2020). Oil and asset classes implied volatilities: Investment strategies and hedging effectiveness. Energy Economics, 91, 104762.
}
\author{
David Gabauer
}
