% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConnectednessTable.R
\name{ConnectednessTable}
\alias{ConnectednessTable}
\title{Connectedness table}
\usage{
ConnectednessTable(FEVD, digit = 2)
}
\arguments{
\item{FEVD}{Forecast error variance decomposition}

\item{digit}{Number of decimal places}
}
\value{
Get connectedness table
}
\description{
This function provides standard connectedness table.
}
\examples{
\donttest{
data(dy2012)
fit = VAR(dy2012, configuration=list(nlag=1))
fevd = FEVD(Phi=fit$B, Sigma=fit$Q, nfore=10, type="time", generalized=TRUE)$FEVD
dca = ConnectednessTable(fevd)
}
}
\references{
Chatziantoniou, I., & Gabauer, D. (2021). EMU risk-synchronisation and financial fragility through the prism of dynamic connectedness. The Quarterly Review of Economics and Finance, 79, 1-14.\\
Gabauer, D. (2021). Dynamic measures of asymmetric & pairwise connectedness within an optimal currency area: Evidence from the ERM I system. Journal of Multinational Financial Management, 60, 100680.
}
