## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----load packages, message=FALSE, warning=FALSE------------------------------
# Load packages
library(ConSciR)
library(dplyr)
library(ggplot2)

## ----table of calculated values, message=FALSE, warning=FALSE-----------------
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata")
mydata <- mydata |> filter(Sensor == "Room 1")


# Add calculated values using mutate
head(mydata) |> 
  mutate(
    Absolute_Humidity = calcAH(Temp, RH), 
    Dew_Point = calcDP(Temp, RH), 
    Mixing_Ratio = calcMR(Temp, RH), 
    Humidity_Ratio = calcHR(Temp, RH),
    Enthalpy = calcEnthalpy(Temp, RH), 
    Saturation_Vapour_Pressure = calcPws(Temp), 
    Actual_Vapour_Pressure = calcPw(Temp, RH), 
    Air_Density = calcAD(Temp, RH),
    Temp_calc = calcTemp(RH, Dew_Point),
    RH_AH_calc = calcRH_AH(Temp, Absolute_Humidity),
    RH_DP_calc = calcRH_DP(Temp, Dew_Point)
  ) |>
  glimpse()


## ----calculations to visualise the data, message=FALSE, warning=FALSE, fig.alt="visualisations"----

mydata |>
  # Calculate Absolute Humidity and Dew Point
  mutate(
    AbsHum = calcAH(Temp, RH),
    DewPoint = calcDP(Temp, RH)
  ) |>
  # Create base plot using graph_TRH function
  graph_TRH() +
  # Add Absolute Humidity line
  geom_line(aes(Date, AbsHum), color = "green") +
  # Add Dew Point line
  geom_line(aes(Date, DewPoint), color = "purple") +
  # Apply a theme
  theme_bw()


## ----mould_risk, message=FALSE, warning=FALSE, fig.alt="mould"----------------
mydata |>
  mutate(Mould = calcMould_VTT(Temp, RH)) |>
  ggplot() +
  geom_area(aes(Date, Mould), fill = "darkgreen", alpha = 0.5) +
  labs(title = "Mould Growth Index", 
       y = "Mould Index") + 
  theme_classic()

## ----psychrometric chart, message=FALSE, warning=FALSE, fig.alt="psychrometric_chart_example"----

head(mydata, 100) |>
  graph_psychrometric() + 
  theme_bw()

## ----psychrometric custom, message=FALSE, warning=FALSE, fig.alt="psychrometric_chart_custom"----

head(mydata, 100) |>
  graph_psychrometric(
    LowT = 10, 
    HighT = 28,
    LowRH = 20, 
    HighRH = 80,
    data_alpha = 0.3,
    y_func = calcAH
  ) + 
  theme_classic()

