# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

W <- function(lam, nu, sumTo) {
    .Call('CompGLM_W', PACKAGE = 'CompGLM', lam, nu, sumTo)
}

Y <- function(lam, nu, sumTo) {
    .Call('CompGLM_Y', PACKAGE = 'CompGLM', lam, nu, sumTo)
}

Z <- function(lam, nu, sumTo) {
    .Call('CompGLM_Z', PACKAGE = 'CompGLM', lam, nu, sumTo)
}

#' @title Conway-Maxwell-Poisson Probability Density Function
#' @author Jeffrey Pollock <jeffpollock9@@gmail.com>
#'
#' @description The PDF of the Conway-Maxwell-Poisson distribution with
#' parameters \code{lam} and \code{nu} at point \code{y}.
#'
#' @details The Conway-Maxwell-Poisson distribution has density:
#' \deqn{P(y) = \frac{\lambda^y}{(y!)^\nu Z(\lambda, \nu)}}{%
#' 	  P(y) = \lambda^y / ((y!)^\nu Z(\lambda, \nu))}
#'       for \eqn{y = 0, 1, 2, \ldots},  and:
#' \deqn{Z(\lambda, \nu) = \sum_{j=0}^\infty \frac{\lambda^j}{(j!)^\nu}}{%
#'       Z(\lambda, \nu) = \sum \lambda^j / ((j!)^\nu)}
#' where the summation is approximated by summing from \code{j = 0} to \code{sumTo}.
#'
#' @param y an integer vector where the density is to be calculated. If the input is not an
#' integer, it will be coerced to be an integer.
#' @param lam a double vector of the parameter \eqn{\lambda}.
#' @param nu a double vector of the parameter \eqn{\nu}.
#' @param sumTo an integer for the summation term in the density (default 100).
#' @param logP a boolean for if the log of the density should be given (default \code{FALSE}).
#'
#' @return The value of the PDF (or log PDF if \code{logP = TRUE}). Input vectors
#' are recycled to be same length.
#'
#' @examples
#' dcomp(-5:5, 2.5, 1)
#' dcomp(2, 2.5, 1.5)
#' require(graphics)
#' require(stats)
#' comp <- dcomp(0:10, 2.5, 0.9)
#' poisson <- dpois(0:10, 2.5)
#' barplot(rbind(comp, poisson), beside = TRUE, names= 0:10, legend.text = TRUE)
#' @export
dcomp <- function(y, lam, nu, sumTo = 100L, logP = FALSE) {
    .Call('CompGLM_dcomp', PACKAGE = 'CompGLM', y, lam, nu, sumTo, logP)
}

#' @title Conway-Maxwell-Poisson Cumulative Density Function
#' @author Jeffrey Pollock <jeffpollock9@@gmail.com>
#'
#' @description The CDF of the Conway-Maxwell-Poisson distribution with parameters
#' \code{lam} and \code{nu} at point \code{q}.
#'
#' @details See \code{\link{dcomp}} for details of the PDF.
#'
#' @param q an integer vector where the CDF is to be calculated. If the input is not an
#' integer, it will be coerced to be an integer.
#' @param lam a double vector of the parameter \eqn{\lambda}.
#' @param nu a double vector of the parameter \eqn{\nu}.
#' @param sumTo an integer for the summation term in the density (default 100)
#' @param lowerTail a boolean for if P(Y<=q) should be returned
#' (default \code{TRUE}), otherwise, P(Y>q) is returned.
#' @param logP a boolean for if the log of the probability should be given (default \code{FALSE})
#'
#' @return The value of the CDF (or 1-CDF if \code{lowerTail = FALSE}) or log of this value if
#' \code{logP = TRUE}. Input vectors are recycled to be same length.
#'
#' @examples
#' pcomp(1:10, 1.5, 1.2)
#' @export
pcomp <- function(q, lam, nu, sumTo = 100L, lowerTail = TRUE, logP = FALSE) {
    .Call('CompGLM_pcomp', PACKAGE = 'CompGLM', q, lam, nu, sumTo, lowerTail, logP)
}

#' @title Conway-Maxwell-Poisson Random Sample
#' @author Jeffrey Pollock <jeffpollock9@@gmail.com>
#'
#' @description Provides a size n sample from the Conway-Maxwell-Poisson distribution
#' with parameters \code{lam} and \code{nu}. Sampling is done via a simple multinomial approach.
#'
#' @details The function is only implemented for single values of \code{lam} and \code{nu}.
#' See \code{\link{dcomp}} for details of the PDF.
#'
#' @param n an integer of the number of random samples to be taken.
#' @param lam a double of the parameter \eqn{\lambda}.
#' @param nu a double of the parameter \eqn{\nu}.
#' @param sumTo an integer for the summation term in the density (default 100).
#'
#' @return A random sample of size n.
#'
#' @examples
#' require(graphics)
#' sample <- rcomp(1000, 8.5, 0.9)
#' barplot(table(sample))
#' @export
rcomp <- function(n, lam, nu, sumTo = 100L) {
    .Call('CompGLM_rcomp', PACKAGE = 'CompGLM', n, lam, nu, sumTo)
}

